/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.audit.impl;

import com.google.common.base.Function;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.AuditContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.joda.time.DateTime;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateAuditContext
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateAuditContext.class);
    @Nonnull
    private Function<ProfileRequestContext, AuditContext> auditContextCreationStrategy = new ChildContextLookup(AuditContext.class, true);
    @Nonnull
    @NonnullElements
    private Map<String, Function<ProfileRequestContext, Object>> fieldExtractors = Collections.emptyMap();
    @Nonnull
    @NonnullElements
    private Set<String> fieldsToExtract = Collections.emptySet();
    @Nullable
    private String dateTimeFormat;
    @Nullable
    private AuditContext auditCtx;

    public void setAuditContextCreationStrategy(@Nonnull Function<ProfileRequestContext, AuditContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.auditContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"AuditContext lookup strategy cannot be null");
    }

    public void setFieldExtractors(@Nonnull @NonnullElements Map<String, Function<ProfileRequestContext, Object>> map) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(map, (String)"Field extractor map cannot be null");
        this.fieldExtractors = new HashMap<String, Function<ProfileRequestContext, Object>>(map.size());
        for (Map.Entry<String, Function<ProfileRequestContext, Object>> entry : map.entrySet()) {
            String field = StringSupport.trimOrNull((String)entry.getKey());
            if (entry.getValue() == null) continue;
            this.fieldExtractors.put(field, entry.getValue());
        }
    }

    public void setFormattingMap(@Nonnull @NonnullElements Map<String, String> map) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(map, (String)"Audit formatting map cannot be null");
        this.fieldsToExtract = new HashSet<String>(10);
        for (String s : map.values()) {
            int len = s.length();
            boolean inToken = false;
            StringBuilder field = new StringBuilder();
            for (int pos = 0; pos < len; ++pos) {
                char ch = s.charAt(pos);
                if (inToken) {
                    if (!Character.isLetterOrDigit(ch) && ch != '-' && ch != '%') {
                        this.fieldsToExtract.add(field.substring(1));
                        field.setLength(0);
                        inToken = false;
                    }
                } else if (ch == '%') {
                    field.setLength(0);
                    inToken = true;
                }
                field.append(ch);
            }
            if (field.length() <= 0 || !inToken) continue;
            this.fieldsToExtract.add(field.substring(1));
        }
    }

    public void setDateTimeFormat(@Nonnull @NotEmpty String format) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.dateTimeFormat = StringSupport.trimOrNull((String)format);
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext) || this.fieldExtractors.isEmpty()) {
            return false;
        }
        this.auditCtx = (AuditContext)this.auditContextCreationStrategy.apply((Object)profileRequestContext);
        if (this.auditCtx == null) {
            this.log.error("{} Unable to create AuditContext", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        for (Map.Entry<String, Function<ProfileRequestContext, Object>> entry : this.fieldExtractors.entrySet()) {
            if (!this.fieldsToExtract.isEmpty() && !this.fieldsToExtract.contains(entry.getKey())) {
                this.log.trace("{} Skipping field '{}' not included in audit format", (Object)this.getLogPrefix(), (Object)entry.getKey());
                continue;
            }
            Object values = entry.getValue().apply((Object)profileRequestContext);
            if (values == null) continue;
            if (values instanceof Collection) {
                if (((Collection)values).isEmpty()) continue;
                this.log.trace("{} Adding {} value(s) for field '{}'", new Object[]{this.getLogPrefix(), ((Collection)values).size(), entry.getKey()});
                for (Object value : (Collection)values) {
                    if (value == null) continue;
                    if (value instanceof DateTime) {
                        this.auditCtx.getFieldValues(entry.getKey()).add(((DateTime)value).toString(this.dateTimeFormat));
                        continue;
                    }
                    this.auditCtx.getFieldValues(entry.getKey()).add(value.toString());
                }
                continue;
            }
            this.log.trace("{} Adding 1 value for field '{}'", (Object)this.getLogPrefix(), (Object)entry.getKey());
            if (values instanceof DateTime) {
                this.auditCtx.getFieldValues(entry.getKey()).add(((DateTime)values).toString(this.dateTimeFormat));
                continue;
            }
            this.auditCtx.getFieldValues(entry.getKey()).add(values.toString());
        }
    }
}

