/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.impl;

import com.google.common.base.MoreObjects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

@ThreadSafe
public class ResolverTestRequest {
    @Nonnull
    @NotEmpty
    private final String principal;
    @Nonnull
    @NotEmpty
    private final String requesterId;
    @Nullable
    private final Integer acsIndex;
    @Nullable
    private final String protocol;

    public ResolverTestRequest(@Nonnull @NotEmpty String princ, @Nullable String requester, @Nullable Integer index, @Nullable String prot) {
        this.principal = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)princ), (String)"Principal name cannot be null or empty");
        this.requesterId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)requester), (String)"Requester name cannot be null or empty");
        this.acsIndex = index;
        this.protocol = StringSupport.trimOrNull((String)prot);
    }

    @Nonnull
    @NotEmpty
    public String getPrincipal() {
        return this.principal;
    }

    @Nonnull
    @NotEmpty
    public String getRequesterId() {
        return this.requesterId;
    }

    @Nullable
    public Integer getAttributeConsumingServiceIndex() {
        return this.acsIndex;
    }

    @Nullable
    public String getProtocol() {
        return this.protocol;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("principal", (Object)this.principal).add("requesterId", (Object)this.requesterId).add("acsIndex", (Object)this.acsIndex).add("protocol", (Object)this.protocol).toString();
    }
}

