/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.support;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.definition.StateDefinition;
import org.springframework.webflow.execution.FlowExecutionListenerAdapter;
import org.springframework.webflow.execution.RequestContext;

public class ProfileRequestContextFlowExecutionListener
extends FlowExecutionListenerAdapter {
    private final Logger log = LoggerFactory.getLogger(ProfileRequestContextFlowExecutionListener.class);

    public void stateEntered(RequestContext context, StateDefinition previousState, StateDefinition newState) {
        if (previousState != null && previousState.getId().startsWith("Initialize")) {
            ProfileRequestContext prc = this.getProfileRequestContext(context);
            ServletRequest request = this.getRequest(context);
            if (prc != null && request != null) {
                this.log.debug("Exposing ProfileRequestContext in servlet request");
                request.setAttribute("opensamlProfileRequestContext", (Object)prc);
            }
        }
    }

    public void resuming(RequestContext context) {
        ProfileRequestContext prc = this.getProfileRequestContext(context);
        ServletRequest request = this.getRequest(context);
        if (prc != null && request != null) {
            this.log.debug("Updating ProfileRequestContext in servlet request");
            request.setAttribute("opensamlProfileRequestContext", (Object)prc);
        }
    }

    @Nullable
    private ProfileRequestContext getProfileRequestContext(@Nonnull RequestContext context) {
        Object prc = context.getConversationScope().get("opensamlProfileRequestContext");
        if (prc instanceof ProfileRequestContext) {
            return (ProfileRequestContext)prc;
        }
        return null;
    }

    @Nullable
    private ServletRequest getRequest(@Nonnull RequestContext context) {
        Object o = context.getExternalContext().getNativeRequest();
        if (o instanceof ServletRequest) {
            return (ServletRequest)o;
        }
        return null;
    }
}

