/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.relyingparty.impl;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.ext.spring.service.ReloadableSpringService;
import net.shibboleth.idp.relyingparty.RelyingPartyConfigurationResolver;
import net.shibboleth.idp.relyingparty.impl.DefaultRelyingPartyConfigurationResolver;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SigningCredentialsResolver
implements CredentialResolver,
IdentifiableComponent {
    private Logger log = LoggerFactory.getLogger(SigningCredentialsResolver.class);
    @Nonnull
    private ReloadableSpringService<RelyingPartyConfigurationResolver> service;
    @Nullable
    private String id;

    public SigningCredentialsResolver(ReloadableSpringService<RelyingPartyConfigurationResolver> resolverService) {
        this.service = (ReloadableSpringService)Constraint.isNotNull(resolverService, (String)"ReloadableSpringService for RelyingPartyConfigurationResolver cannot be null");
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(@Nonnull String componentId) {
        this.id = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)componentId), (String)"Component ID can not be null or empty");
    }

    @Nullable
    public Credential resolveSingle(@Nullable CriteriaSet criteriaSet) throws ResolverException {
        Iterable<Credential> creds = this.resolve(criteriaSet);
        if (creds.iterator().hasNext()) {
            return creds.iterator().next();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<Credential> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        block7: {
            ServiceableComponent component = null;
            try {
                component = this.service.getServiceableComponent();
                if (null == component) {
                    this.log.error("SigningCredentialsResolver '{}': error looking up relying party configuration service: Invalid configuration.", (Object)this.getId());
                    break block7;
                }
                RelyingPartyConfigurationResolver resolver = (RelyingPartyConfigurationResolver)component.getComponent();
                if (resolver instanceof DefaultRelyingPartyConfigurationResolver) {
                    this.log.trace("Saw expected instance of DefaultRelyingPartyConfigurationResolver");
                    List<Credential> list = ((DefaultRelyingPartyConfigurationResolver)resolver).getSigningCredentials();
                    return list;
                }
                this.log.trace("Did NOT see expected instance of DefaultRelyingPartyConfigurationResolver");
                List<Credential> list = Collections.emptyList();
                return list;
            }
            finally {
                if (null != component) {
                    component.unpinComponent();
                }
            }
        }
        return null;
    }
}

