/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.authn.ExternalAuthenticationException;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.net.URISupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class ExternalAuthentication {
    @Nonnull
    @NotEmpty
    public static final String CONVERSATION_KEY = "conversation";
    @Nonnull
    @NotEmpty
    public static final String PRINCIPAL_KEY = "principal";
    @Nonnull
    @NotEmpty
    public static final String PRINCIPAL_NAME_KEY = "principal_name";
    @Nonnull
    @NotEmpty
    public static final String SUBJECT_KEY = "subject";
    @Nonnull
    @NotEmpty
    public static final String AUTHENTICATION_INSTANT_KEY = "authnInstant";
    @Nonnull
    @NotEmpty
    public static final String AUTHENTICATION_ERROR_KEY = "authnError";
    @Nonnull
    @NotEmpty
    public static final String AUTHENTICATION_EXCEPTION_KEY = "authnException";
    @Nonnull
    @NotEmpty
    public static final String DONOTCACHE_KEY = "doNotCache";
    @Nonnull
    @NotEmpty
    public static final String REVOKECONSENT_KEY = "revokeConsent";
    @Nonnull
    @NotEmpty
    public static final String FORCE_AUTHN_PARAM = "forceAuthn";
    @Nonnull
    @NotEmpty
    public static final String PASSIVE_AUTHN_PARAM = "isPassive";
    @Deprecated
    @Nonnull
    @NotEmpty
    public static final String AUTHN_METHOD_PARAM = "authnMethod";
    @Nonnull
    @NotEmpty
    public static final String RELYING_PARTY_PARAM = "relyingParty";
    @Nonnull
    @NotEmpty
    public static final String EXTENDED_FLOW_PARAM = "extended";

    @Nonnull
    @NotEmpty
    public static String getExternalRedirect(@Nonnull @NotEmpty String baseLocation, @Nonnull @NotEmpty String conversationValue) {
        Constraint.isNotEmpty((String)baseLocation, (String)"Base location cannot be null or empty");
        StringBuilder url = new StringBuilder(baseLocation);
        url.append(baseLocation.indexOf(63) == -1 ? (char)'?' : '&');
        url.append(CONVERSATION_KEY).append('=').append(URISupport.doURLEncode((String)conversationValue));
        return url.toString();
    }

    @Nonnull
    @NotEmpty
    public static String startExternalAuthentication(@Nonnull HttpServletRequest request) throws ExternalAuthenticationException {
        String conv = request.getParameter(CONVERSATION_KEY);
        if (conv == null || conv.isEmpty()) {
            throw new ExternalAuthenticationException("No conversation key found in request");
        }
        Object obj = request.getSession().getAttribute(CONVERSATION_KEY + conv);
        if (obj == null || !(obj instanceof ExternalAuthentication)) {
            throw new ExternalAuthenticationException("No conversation state found in session for key (" + conv + ")");
        }
        ((ExternalAuthentication)obj).doStart(request);
        return conv;
    }

    public static void finishExternalAuthentication(@Nonnull @NotEmpty String key, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) throws ExternalAuthenticationException, IOException {
        Object obj = request.getSession().getAttribute(CONVERSATION_KEY + key);
        if (obj == null || !(obj instanceof ExternalAuthentication)) {
            throw new ExternalAuthenticationException("No conversation state found in session for key (" + key + ")");
        }
        request.getSession().removeAttribute(CONVERSATION_KEY + key);
        ((ExternalAuthentication)obj).doFinish(request, response);
    }

    @Nonnull
    public static ProfileRequestContext getProfileRequestContext(@Nonnull @NotEmpty String key, @Nonnull HttpServletRequest request) throws ExternalAuthenticationException {
        Object obj = request.getSession().getAttribute(CONVERSATION_KEY + key);
        if (obj == null || !(obj instanceof ExternalAuthentication)) {
            throw new ExternalAuthenticationException("No conversation state found in session");
        }
        return ((ExternalAuthentication)obj).getProfileRequestContext(request);
    }

    protected void doStart(@Nonnull HttpServletRequest request) throws ExternalAuthenticationException {
        throw new ExternalAuthenticationException("Not implemented");
    }

    protected void doFinish(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) throws ExternalAuthenticationException, IOException {
        throw new ExternalAuthenticationException("Not implemented");
    }

    @Nonnull
    protected ProfileRequestContext getProfileRequestContext(@Nonnull HttpServletRequest request) throws ExternalAuthenticationException {
        throw new ExternalAuthenticationException("Not implemented");
    }
}

