/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.context;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.BaseContext;

public class RequestedPrincipalContext
extends BaseContext {
    @Nullable
    private String operatorString;
    @Nonnull
    @NonnullElements
    private List<Principal> requestedPrincipals = Collections.emptyList();
    @Nullable
    private Principal matchingPrincipal;

    @Nonnull
    @NotEmpty
    public String getOperator() {
        return this.operatorString;
    }

    public void setOperator(@Nullable String operator) {
        this.operatorString = StringSupport.trimOrNull((String)operator);
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public List<Principal> getRequestedPrincipals() {
        return ImmutableList.copyOf(this.requestedPrincipals);
    }

    public void setRequestedPrincipals(@Nonnull @NonnullElements List<Principal> principals) {
        Constraint.isNotNull(principals, (String)"Principal list cannot be null");
        this.requestedPrincipals = new ArrayList<Principal>(Collections2.filter(principals, (Predicate)Predicates.notNull()));
    }

    @Nullable
    public Principal getMatchingPrincipal() {
        return this.matchingPrincipal;
    }

    public void setMatchingPrincipal(@Nullable Principal principal) {
        this.matchingPrincipal = principal;
    }
}

