/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;

public class StringAttributeValue
implements IdPAttributeValue<String> {
    @Nonnull
    @NotEmpty
    private final String value;

    public StringAttributeValue(@Nonnull @NotEmpty String attributeValue) {
        this.value = Constraint.isNotEmpty((String)attributeValue, (String)"Attribute value cannot be null or empty");
    }

    @Override
    @Nonnull
    @NotEmpty
    public final String getValue() {
        return this.value;
    }

    @Override
    @Nonnull
    @NotEmpty
    public String getDisplayValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StringAttributeValue)) {
            return false;
        }
        StringAttributeValue other = (StringAttributeValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).toString();
    }

    @Nonnull
    public static IdPAttributeValue<?> valueOf(@Nullable String value) {
        if (value == null) {
            return EmptyAttributeValue.NULL;
        }
        if (value.length() == 0) {
            return EmptyAttributeValue.ZERO_LENGTH;
        }
        return new StringAttributeValue(value);
    }
}

