/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.spring;

import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.security.RandomIdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BaseFilterParser
extends AbstractSingleBeanDefinitionParser {
    public static final String NAMESPACE = "urn:mace:shibboleth:2.0:afp";
    public static final QName AFP_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:afp", "AttributeFilterPolicyGroup");
    public static final QName POLICY_REQUIREMENT_RULE = new QName("urn:mace:shibboleth:2.0:afp", "PolicyRequirementRule");
    public static final QName PERMIT_VALUE_RULE = new QName("urn:mace:shibboleth:2.0:afp", "PermitValueRule");
    public static final QName DENY_VALUE_RULE = new QName("urn:mace:shibboleth:2.0:afp", "DenyValueRule");
    private static IdentifierGenerationStrategy idGen = new RandomIdentifierGenerationStrategy();
    private final Logger log = LoggerFactory.getLogger(BaseFilterParser.class);

    @Nonnull
    @NotEmpty
    protected String getQualifiedId(@Nonnull Element configElement, @Nonnull String componentNamespace, @Nullable String localId) {
        Element afpgElement = configElement.getOwnerDocument().getDocumentElement();
        String policyGroupId = StringSupport.trimOrNull((String)afpgElement.getAttributeNS(null, "id"));
        StringBuilder qualifiedId = new StringBuilder();
        qualifiedId.append("/");
        qualifiedId.append(AFP_ELEMENT_NAME.getLocalPart());
        qualifiedId.append(":");
        qualifiedId.append(policyGroupId);
        if (!Strings.isNullOrEmpty((String)componentNamespace)) {
            qualifiedId.append("/");
            qualifiedId.append(componentNamespace);
            qualifiedId.append(":");
            if (Strings.isNullOrEmpty((String)localId)) {
                qualifiedId.append(idGen.generateIdentifier());
            } else {
                qualifiedId.append(localId);
            }
        }
        return qualifiedId.toString();
    }

    @Nullable
    protected String getReferenceText(@Nonnull Element element) {
        String reference = StringSupport.trimOrNull((String)element.getAttributeNS(null, "ref"));
        return reference;
    }

    @Nonnull
    @NotEmpty
    protected String getAbsoluteReference(@Nonnull Element configElement, @Nonnull @NotEmpty String componentNamespace, @Nonnull @NotEmpty String reference) {
        if (reference.startsWith("/")) {
            return reference;
        }
        return this.getQualifiedId(configElement, componentNamespace, reference);
    }

    protected void doParse(@Nonnull Element element, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        builder.setInitMethodName("initialize");
        builder.setDestroyMethodName("destroy");
        builder.setScope("prototype");
        super.doParse(element, parserContext, builder);
        String suppliedId = StringSupport.trimOrNull((String)element.getAttributeNS(null, "id"));
        String generatedId = this.getQualifiedId(element, element.getLocalName(), suppliedId);
        if (suppliedId == null) {
            this.log.trace("Element '{}' did not contain an 'id' attribute.  Generated id '{}' will be used", (Object)element.getLocalName(), (Object)generatedId);
        } else {
            this.log.debug("Element '{}' 'id' attribute '{}' is mapped to '{}'", new Object[]{element.getLocalName(), suppliedId, generatedId});
        }
        builder.getBeanDefinition().setAttribute("qualifiedId", (Object)generatedId);
    }

    @Nonnull
    @NotEmpty
    protected String resolveId(@Nonnull Element configElement, @Nonnull AbstractBeanDefinition beanDefinition, @Nonnull ParserContext parserContext) {
        return beanDefinition.getAttribute("qualifiedId").toString();
    }

    protected boolean isPolicyRule(@Nonnull Element element) {
        Element elem = element;
        do {
            if (ElementSupport.isElementNamed((Element)elem, (QName)POLICY_REQUIREMENT_RULE)) {
                return true;
            }
            if (!ElementSupport.isElementNamed((Element)elem, (QName)DENY_VALUE_RULE) && !ElementSupport.isElementNamed((Element)elem, (QName)PERMIT_VALUE_RULE)) continue;
            return false;
        } while ((elem = ElementSupport.getElementAncestor((Node)elem)) != null);
        this.log.warn("Element '{}' : could not find schema defined parent");
        return false;
    }
}

