/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.spring.impl;

import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.filter.spring.BaseFilterParser;
import net.shibboleth.utilities.java.support.xml.DOMTypeSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class AbstractWarningFilterParser
extends BaseFilterParser {
    private static boolean warnedSAML;
    private static boolean warnedBasic;
    private final Logger log = LoggerFactory.getLogger(AbstractWarningFilterParser.class);

    @Override
    protected void doParse(@Nonnull Element element, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        QName suppliedQname = DOMTypeSupport.getXSIType((Element)element);
        if ("urn:mace:shibboleth:2.0:afp:mf:saml".equals(suppliedQname.getNamespaceURI())) {
            if (!warnedSAML) {
                warnedSAML = true;
                this.log.warn("Configuration contains at least one element in the deprecated '{}' namespace.", (Object)"urn:mace:shibboleth:2.0:afp:mf:saml");
            }
            this.log.debug("saml: Namespace element {} in {}, consider using {}", new Object[]{suppliedQname.toString(), parserContext.getReaderContext().getResource().getDescription(), this.getAFPName().toString()});
        } else if ("urn:mace:shibboleth:2.0:afp:mf:basic".equals(suppliedQname.getNamespaceURI())) {
            if (!warnedBasic) {
                warnedBasic = true;
                this.log.warn("Configuration contains at least one element in the deprecated '{}' namespace.", (Object)"urn:mace:shibboleth:2.0:afp:mf:basic");
            }
            this.log.debug("basic: Namespace element {} in {}, consider using {}", new Object[]{suppliedQname.toString(), parserContext.getReaderContext().getResource().getDescription(), this.getAFPName().toString()});
        }
        super.doParse(element, parserContext, builder);
    }

    protected abstract QName getAFPName();
}

