/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.spring.impl;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.util.SpringSupport;
import net.shibboleth.idp.attribute.filter.AttributeFilterPolicy;
import net.shibboleth.idp.attribute.filter.spring.BaseFilterParser;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AttributeFilterPolicyParser
extends BaseFilterParser {
    public static final QName ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:afp", "AttributeFilterPolicy");
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:afp", "AttributeFilterPolicyType");
    public static final QName POLICY_REQUIREMENT_RULE_REF = new QName("urn:mace:shibboleth:2.0:afp", "PolicyRequirementRuleReference");
    private static final QName ATTRIBUTE_RULE = new QName("urn:mace:shibboleth:2.0:afp", "AttributeRule");
    private static final QName ATTRIBUTE_RULE_REF = new QName("urn:mace:shibboleth:2.0:afp", "AttributeRuleReference");
    private Logger log = LoggerFactory.getLogger(AttributeFilterPolicyParser.class);

    protected Class<?> getBeanClass(Element arg0) {
        return AttributeFilterPolicy.class;
    }

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        List rulesRef;
        super.doParse(config, parserContext, builder);
        String policyId = StringSupport.trimOrNull((String)config.getAttributeNS(null, "id"));
        if (null == policyId) {
            policyId = builder.getBeanDefinition().getAttribute("qualifiedId").toString();
        }
        this.log.debug("Parsing configuration for attribute filter policy: {}", (Object)policyId);
        builder.addConstructorArgValue((Object)policyId);
        List policyRequirements = ElementSupport.getChildElements((Node)config, (QName)BaseFilterParser.POLICY_REQUIREMENT_RULE);
        if (policyRequirements != null && policyRequirements.size() > 0) {
            ManagedList requirements = SpringSupport.parseCustomElements((Collection)policyRequirements, (ParserContext)parserContext);
            builder.addConstructorArgValue(requirements.get(0));
        } else {
            List policyRequirementsRef = ElementSupport.getChildElements((Node)config, (QName)POLICY_REQUIREMENT_RULE_REF);
            if (policyRequirementsRef != null && policyRequirementsRef.size() > 0) {
                String referenceText = this.getReferenceText((Element)policyRequirementsRef.get(0));
                if (null == referenceText) {
                    throw new BeanCreationException("Attribute Filter '" + policyId + "' no text or reference for " + POLICY_REQUIREMENT_RULE_REF);
                }
                String reference = this.getAbsoluteReference(config, "PolicyRequirementRule", referenceText);
                this.log.debug("Adding PolicyRequirementRule reference to {}", (Object)reference);
                builder.addConstructorArgValue((Object)new RuntimeBeanReference(reference));
            } else {
                throw new BeanCreationException("Attribute Filter '" + policyId + "' A PolicyRequirementRule or a PolicyRequirementRuleReference should be present");
            }
        }
        ManagedList attributeRules = new ManagedList();
        List rules = ElementSupport.getChildElements((Node)config, (QName)ATTRIBUTE_RULE);
        if (rules != null && rules.size() > 0) {
            attributeRules.addAll((Collection)SpringSupport.parseCustomElements((Collection)rules, (ParserContext)parserContext));
        }
        if ((rulesRef = ElementSupport.getChildElements((Node)config, (QName)ATTRIBUTE_RULE_REF)) != null && rulesRef.size() > 0) {
            for (Element ruleRef : rulesRef) {
                String reference = this.getAbsoluteReference(config, "AttributeRule", this.getReferenceText(ruleRef));
                attributeRules.add((Object)new RuntimeBeanReference(reference));
            }
        }
        builder.addConstructorArgValue((Object)attributeRules);
    }
}

