/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.spring.impl;

import com.google.common.base.Function;
import java.util.Collection;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.filter.AttributeFilter;
import net.shibboleth.idp.attribute.filter.AttributeFilterPolicy;
import net.shibboleth.idp.attribute.filter.impl.AttributeFilterImpl;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.service.ServiceException;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class AttributeFilterServiceStrategy
extends AbstractIdentifiableInitializableComponent
implements Function<ApplicationContext, ServiceableComponent<AttributeFilter>> {
    private final Logger log = LoggerFactory.getLogger(AttributeFilterServiceStrategy.class);

    @Nullable
    public ServiceableComponent<AttributeFilter> apply(@Nullable ApplicationContext appContext) {
        Collection afps = appContext.getBeansOfType(AttributeFilterPolicy.class).values();
        this.log.debug("Creating Attribute Filter {} with  {} Policies", (Object)this.getId(), (Object)afps.size());
        AttributeFilterImpl filter = new AttributeFilterImpl(this.getId(), afps);
        filter.setApplicationContext(appContext);
        try {
            filter.initialize();
        }
        catch (ComponentInitializationException e) {
            throw new ServiceException("Unable to initialize attribute filter for " + appContext.getDisplayName(), (Exception)((Object)e));
        }
        return filter;
    }
}

