/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.spring.impl;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.util.SpringSupport;
import net.shibboleth.idp.attribute.filter.AttributeRule;
import net.shibboleth.idp.attribute.filter.Matcher;
import net.shibboleth.idp.attribute.filter.spring.BaseFilterParser;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AttributeRuleParser
extends BaseFilterParser {
    public static final QName ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:afp", "AttributeRule");
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:afp", "AttributeRuleType");
    public static final QName PERMIT_VALUE_REF = new QName("urn:mace:shibboleth:2.0:afp", "PermitValueRuleReference");
    public static final QName DENY_VALUE_REF = new QName("urn:mace:shibboleth:2.0:afp", "DenyValueRuleReference");
    public static final String PERMIT_ANY_ATTRIBUTE = "permitAny";
    private final Logger log = LoggerFactory.getLogger(AttributeRuleParser.class);

    @Nonnull
    protected Class<?> getBeanClass(@Nullable Element arg) {
        return AttributeRule.class;
    }

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        String id = builder.getBeanDefinition().getAttribute("qualifiedId").toString();
        builder.addPropertyValue("id", (Object)id);
        String attributeId = StringSupport.trimOrNull((String)config.getAttributeNS(null, "attributeID"));
        builder.addPropertyValue("attributeId", (Object)attributeId);
        List permitValueRule = ElementSupport.getChildElements((Node)config, (QName)BaseFilterParser.PERMIT_VALUE_RULE);
        List permitValueReference = ElementSupport.getChildElements((Node)config, (QName)PERMIT_VALUE_REF);
        List denyValueRule = ElementSupport.getChildElements((Node)config, (QName)BaseFilterParser.DENY_VALUE_RULE);
        List denyValueReference = ElementSupport.getChildElements((Node)config, (QName)DENY_VALUE_REF);
        if (permitValueRule != null && !permitValueRule.isEmpty()) {
            ManagedList permitValueRules = SpringSupport.parseCustomElements((Collection)permitValueRule, (ParserContext)parserContext);
            this.log.debug("permitValueRules {}", (Object)permitValueRules);
            builder.addPropertyValue("matcher", permitValueRules.get(0));
            builder.addPropertyValue("isDenyRule", (Object)false);
        } else if (permitValueReference != null && !permitValueReference.isEmpty()) {
            String referenceText = this.getReferenceText((Element)permitValueReference.get(0));
            if (null == referenceText) {
                throw new BeanCreationException("Attribute Rule '" + id + "' no text or reference for " + PERMIT_VALUE_REF);
            }
            String reference = this.getAbsoluteReference(config, "PermitValueRule", referenceText);
            this.log.debug("Adding PermitValueRule reference to {}", (Object)reference);
            builder.addPropertyValue("matcher", (Object)new RuntimeBeanReference(reference));
            builder.addPropertyValue("isDenyRule", (Object)false);
        } else if (denyValueRule != null && !denyValueRule.isEmpty()) {
            ManagedList denyValueRules = SpringSupport.parseCustomElements((Collection)denyValueRule, (ParserContext)parserContext);
            this.log.debug("denyValueRules {}", (Object)denyValueRules);
            builder.addPropertyValue("matcher", denyValueRules.get(0));
            builder.addPropertyValue("isDenyRule", (Object)true);
        } else if (denyValueReference != null && !denyValueReference.isEmpty()) {
            String referenceText = this.getReferenceText((Element)denyValueReference.get(0));
            if (null == referenceText) {
                throw new BeanCreationException("Attribute Rule '" + id + "' no text or reference for " + DENY_VALUE_REF);
            }
            String reference = this.getAbsoluteReference(config, "DenyValueRule", referenceText);
            this.log.debug("Adding DenyValueRule reference to {}", (Object)reference);
            builder.addPropertyValue("matcher", (Object)new RuntimeBeanReference(reference));
            builder.addPropertyValue("isDenyRule", (Object)true);
        } else if (config.hasAttributeNS(null, PERMIT_ANY_ATTRIBUTE) && AttributeSupport.getAttributeValueAsBoolean((Attr)config.getAttributeNodeNS(null, PERMIT_ANY_ATTRIBUTE)).booleanValue()) {
            builder.addPropertyValue("isDenyRule", (Object)false);
            builder.addPropertyValue("matcher", (Object)Matcher.MATCHES_ALL);
        } else {
            this.log.warn("Attribute rule must have one of PermitValueRule, DenyValueRule or have attribute permitAny=\"true\"");
        }
    }
}

