/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.spring.matcher;

import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.filter.MatcherFromPolicy;
import net.shibboleth.idp.attribute.filter.PolicyFromMatcher;
import net.shibboleth.idp.attribute.filter.PolicyFromMatcherId;
import net.shibboleth.idp.attribute.filter.spring.impl.AbstractWarningFilterParser;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class BaseAttributeValueMatcherParser
extends AbstractWarningFilterParser {
    public static final String ATTRIBUTE_ID = "attributeID";

    protected boolean hasAttributeId(@Nonnull Element configElement) {
        return configElement.hasAttributeNS(null, ATTRIBUTE_ID);
    }

    @Nonnull
    protected Class<?> getBeanClass(@Nonnull Element element) {
        if (this.isPolicyRule(element)) {
            if (this.hasAttributeId(element)) {
                return PolicyFromMatcherId.class;
            }
            return PolicyFromMatcher.class;
        }
        if (this.hasAttributeId(element)) {
            return MatcherFromPolicy.class;
        }
        return this.getNativeBeanClass();
    }

    @Override
    protected void doParse(@Nonnull Element element, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        String myId = builder.getBeanDefinition().getAttribute("qualifiedId").toString();
        builder.addPropertyValue("id", (Object)myId);
        if (this.isPolicyRule(element)) {
            BeanDefinitionBuilder childBuilder = BeanDefinitionBuilder.genericBeanDefinition(this.getNativeBeanClass());
            childBuilder.setInitMethodName("initialize");
            childBuilder.setDestroyMethodName("destroy");
            this.doNativeParse(element, parserContext, childBuilder);
            childBuilder.addPropertyValue("id", (Object)("PMId:" + myId));
            builder.addConstructorArgValue((Object)childBuilder.getBeanDefinition());
            if (this.hasAttributeId(element)) {
                builder.addConstructorArgValue((Object)element.getAttributeNS(null, ATTRIBUTE_ID));
            }
        } else if (this.hasAttributeId(element)) {
            BeanDefinitionBuilder childBuilder = BeanDefinitionBuilder.genericBeanDefinition(PolicyFromMatcherId.class);
            childBuilder.setInitMethodName("initialize");
            childBuilder.setDestroyMethodName("destroy");
            BeanDefinitionBuilder grandChildBuilder = BeanDefinitionBuilder.genericBeanDefinition(this.getNativeBeanClass());
            grandChildBuilder.setInitMethodName("initialize");
            grandChildBuilder.setDestroyMethodName("destroy");
            this.doNativeParse(element, parserContext, grandChildBuilder);
            grandChildBuilder.addPropertyValue("id", (Object)("PMId:" + myId));
            childBuilder.addPropertyValue("id", (Object)("MfP:" + myId));
            childBuilder.addConstructorArgValue((Object)grandChildBuilder.getBeanDefinition());
            childBuilder.addConstructorArgValue((Object)element.getAttributeNS(null, ATTRIBUTE_ID));
            builder.addConstructorArgValue((Object)childBuilder.getBeanDefinition());
        } else {
            this.doNativeParse(element, parserContext, builder);
        }
    }

    @Nonnull
    protected abstract Class<?> getNativeBeanClass();

    protected abstract void doNativeParse(@Nonnull Element var1, @Nonnull ParserContext var2, @Nonnull BeanDefinitionBuilder var3);
}

