/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.spring.saml.impl;

import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.util.SpringSupport;
import net.shibboleth.idp.attribute.filter.policyrule.saml.impl.RegistrationAuthorityPolicyRule;
import net.shibboleth.idp.attribute.filter.spring.policyrule.BasePolicyRuleParser;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class RegistrationAuthorityRuleParser
extends BasePolicyRuleParser {
    public static final QName SCHEMA_TYPE = new QName("urn:mace:shibboleth:2.0:afp:mf:saml", "RegistrationAuthority");
    public static final QName SCHEMA_TYPE_AFP = new QName("urn:mace:shibboleth:2.0:afp", "RegistrationAuthority");
    public static final String REGISTRARS_ATTR_NAME = "registrars";
    public static final String MATCH_IF_METADATA_SILENT_ATTR_NAME = "matchIfMetadataSilent";
    private final Logger log = LoggerFactory.getLogger(RegistrationAuthorityRuleParser.class);

    protected Class<RegistrationAuthorityPolicyRule> getNativeBeanClass() {
        return RegistrationAuthorityPolicyRule.class;
    }

    @Override
    protected QName getAFPName() {
        return SCHEMA_TYPE_AFP;
    }

    @Override
    protected void doNativeParse(@Nonnull Element element, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        Attr attr;
        if (element.hasAttributeNS(null, MATCH_IF_METADATA_SILENT_ATTR_NAME)) {
            String matchIfSilent = StringSupport.trimOrNull((String)element.getAttributeNS(null, MATCH_IF_METADATA_SILENT_ATTR_NAME));
            this.log.debug("Registration Authority Filter: Match if Metadata silent = {}", (Object)matchIfSilent);
            builder.addPropertyValue(MATCH_IF_METADATA_SILENT_ATTR_NAME, (Object)matchIfSilent);
        }
        if ((attr = element.getAttributeNodeNS(null, REGISTRARS_ATTR_NAME)) != null) {
            ManagedList issuers = SpringSupport.getAttributeValueAsManagedList((Attr)attr);
            this.log.debug("Registration Authority Filter: Issuers = {}", (Object)issuers);
            builder.addPropertyValue("issuers", (Object)issuers);
        }
    }
}

