/*
 * Decompiled with CFR 0.152.
 */
package org.openliberty.wsc;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.apache.log4j.Logger;
import org.openliberty.wsc.BaseServiceClient;
import org.openliberty.wsc.DiscoveryService;
import org.openliberty.wsc.WSFMessage;
import org.openliberty.xmltooling.idsis.dap.DAPData;
import org.openliberty.xmltooling.idsis.dap.DAPItemData;
import org.openliberty.xmltooling.idsis.dap.DAPModify;
import org.openliberty.xmltooling.idsis.dap.DAPModifyResponse;
import org.openliberty.xmltooling.idsis.dap.DAPQuery;
import org.openliberty.xmltooling.idsis.dap.DAPQueryResponse;
import org.openliberty.xmltooling.soapbinding.ProcessingContext;
import org.openliberty.xmltooling.wsa.EndpointReference;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.soap.soap11.Body;

public class DirectoryAccessProtocolService
extends BaseServiceClient {
    protected static Logger log = Logger.getLogger(DirectoryAccessProtocolService.class);
    public static final String SERVICE_URN = DiscoveryService.WSFServiceType.DIRECTORY_ACCESS_PROTOCOL_SERVICE.getUrn();
    public static final String OPTION_NO_SORTING = "urn:liberty:dst:noSorting";
    public static final String OPTION_NO_PAGINATION = "urn:liberty:dst:noPagination";
    public static final String OPTION_NO_STATIC = "urn:liberty:dst:noStatic";
    public static final String OPTION_NO_SUBSCRIBE = "urn:liberty:dst:noSubscribe";
    public static final String SIMULATION_URN = ProcessingContext.Defined.SIMULATE.getUri();

    public DirectoryAccessProtocolService(DiscoveryService discoveryService, EndpointReference initialEndpointReference) {
        super(discoveryService, initialEndpointReference);
    }

    public static DirectoryAccessProtocolService serviceForEndpointReference(DiscoveryService discoveryService, EndpointReference epr) {
        DirectoryAccessProtocolService service = new DirectoryAccessProtocolService(discoveryService, epr);
        return service;
    }

    public boolean serviceDoesNotSupportSorting() {
        return this.serviceExplicitlySupportsOption(OPTION_NO_SORTING);
    }

    public boolean serviceDoesNotSupportPagination() {
        return this.serviceExplicitlySupportsOption(OPTION_NO_PAGINATION);
    }

    public boolean serviceDoesNotSupportStatic() {
        return this.serviceExplicitlySupportsOption(OPTION_NO_STATIC);
    }

    public boolean serviceDoesNotSupportSubscribe() {
        return this.serviceExplicitlySupportsOption(OPTION_NO_SUBSCRIBE);
    }

    public Hashtable<String, String> modifyEntityAttributes(Hashtable<String, String> attributes, boolean isSimulation) {
        StringBuffer sbuff = new StringBuffer();
        Enumeration<String> e = attributes.keys();
        while (e.hasMoreElements()) {
            if (sbuff.length() > 0) {
                sbuff.append("\n");
            }
            String key = e.nextElement();
            sbuff.append(key).append(": ").append(attributes.get(key));
        }
        DAPModify dapModify = new DAPModify(sbuff.toString());
        DAPModifyResponse response = this.modify(dapModify, isSimulation);
        if (log.isDebugEnabled()) {
            if (null != response.getStatus()) {
                log.debug((Object)("Status Code: " + response.getStatus().getCode()));
            } else {
                log.debug((Object)"Status Code: DAPQueryResponse has no <Status> element!");
            }
        }
        Hashtable<String, String> responseAttributes = new Hashtable<String, String>();
        if (null != response) {
            XMLObjectChildrenList<DAPItemData> dataList = response.getItemDataList();
            for (DAPItemData data : dataList) {
                data.getLDIF();
            }
        }
        return responseAttributes;
    }

    public Hashtable<String, String> getEntityAttributes(List<String> attributeNames, boolean isSimulation) {
        Hashtable<String, String> attributes = new Hashtable<String, String>();
        StringBuffer attributeNamesBuff = new StringBuffer();
        for (String attributeName : attributeNames) {
            if (attributeName.length() <= 0) continue;
            if (attributeNamesBuff.length() > 0) {
                attributeNamesBuff.append(",");
            }
            attributeNamesBuff.append(attributeName);
        }
        DAPQuery query = DAPQuery.entityQueryWithSelectAttributes(attributeNamesBuff.toString(), null);
        DAPQueryResponse response = this.invokeQuery(query, isSimulation);
        if (log.isDebugEnabled()) {
            if (null != response.getStatus()) {
                log.debug((Object)("Status Code: " + response.getStatus().getCode()));
            } else {
                log.debug((Object)"Status Code: DAPQueryResponse has no <Status> element!");
            }
        }
        if (null != response) {
            XMLObjectChildrenList<DAPData> dataList = response.getDAPDatas();
            for (DAPData data : dataList) {
                attributes.putAll(data.getLDIFDataAsHashtable());
            }
        }
        return attributes;
    }

    public DAPQueryResponse invokeQuery(DAPQuery query, boolean isSimulation) {
        ArrayList<DAPQuery> queries = new ArrayList<DAPQuery>();
        queries.add(query);
        List<DAPQueryResponse> responses = this.invokeQueries(queries, isSimulation);
        if (responses.size() == 1) {
            return responses.get(0);
        }
        return null;
    }

    public List<DAPQueryResponse> invokeQueries(List<DAPQuery> queries, boolean isSimulation) {
        ArrayList<DAPQueryResponse> queryResponses = new ArrayList<DAPQueryResponse>();
        Body responseBody = this.invokeRequest(queries, RequestType.QUERY, isSimulation);
        if (null != responseBody) {
            for (XMLObject obj : responseBody.getUnknownXMLObjects()) {
                if (!(obj instanceof DAPQueryResponse)) continue;
                queryResponses.add((DAPQueryResponse)obj);
            }
        }
        return queryResponses;
    }

    public DAPModifyResponse modify(DAPModify request, boolean isSimulation) {
        ArrayList<DAPModify> requests = new ArrayList<DAPModify>();
        requests.add(request);
        List<DAPModifyResponse> responses = this.modify(requests, isSimulation);
        if (responses.size() == 1) {
            return responses.get(0);
        }
        return null;
    }

    public List<DAPModifyResponse> modify(List<DAPModify> modifications, boolean isSimulation) {
        ArrayList<DAPModifyResponse> responses = new ArrayList<DAPModifyResponse>();
        Body responseBody = this.invokeRequest(modifications, RequestType.MODIFY, isSimulation);
        if (null != responseBody) {
            for (XMLObject obj : responseBody.getUnknownXMLObjects()) {
                if (!(obj instanceof DAPModifyResponse)) continue;
                responses.add((DAPModifyResponse)obj);
            }
        }
        return responses;
    }

    private Body invokeRequest(List bodyObjects, RequestType requestType, boolean isSimulation) {
        WSFMessage queryMessage = null;
        try {
            queryMessage = WSFMessage.createWSFMessage(this, SERVICE_URN + requestType.getActionSuffix());
        }
        catch (XMLParserException e1) {
            e1.printStackTrace();
            return null;
        }
        catch (UnmarshallingException e1) {
            e1.printStackTrace();
            return null;
        }
        if (isSimulation) {
            ProcessingContext processingContext = new ProcessingContext();
            processingContext.setValue(SIMULATION_URN);
            queryMessage.setHeaderProcessingContext(processingContext);
        }
        queryMessage.getRequestEnvelope().getBody().getUnknownXMLObjects().addAll(bodyObjects);
        if (log.isDebugEnabled()) {
            log.debug((Object)WSFMessage.prettyPrintRequestMessage(queryMessage));
        }
        try {
            queryMessage.invoke();
            if (log.isDebugEnabled()) {
                log.debug((Object)WSFMessage.prettyPrintResponseMessage(queryMessage));
            }
            return queryMessage.getResponseEnvelope().getBody();
        }
        catch (Exception e) {
            log.error((Object)"Exception while attempting to invoke a WSFMessage", (Throwable)e);
            if (log.isDebugEnabled()) {
                log.debug((Object)WSFMessage.prettyPrintResponseMessage(queryMessage));
            }
            return null;
        }
    }

    public static enum RequestType {
        QUERY(":Query"),
        MODIFY(":Modify"),
        CREATE(":Create"),
        DELETE(":Delete"),
        NOTIFY(":Notify");

        private String actionSuffix;

        private RequestType(String actionSuffix) {
            this.actionSuffix = actionSuffix;
        }

        public String getActionSuffix() {
            return this.actionSuffix;
        }
    }
}

