/*
 * Decompiled with CFR 0.152.
 */
package org.openliberty.wsc;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.openliberty.wsc.BaseServiceClient;
import org.openliberty.wsc.DiscoveryService;
import org.openliberty.wsc.WSFMessage;
import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.dst2_1.ref.Data;
import org.openliberty.xmltooling.dst2_1.ref.DefaultBuilder;
import org.openliberty.xmltooling.dst2_1.ref.Modify;
import org.openliberty.xmltooling.dst2_1.ref.ModifyItem;
import org.openliberty.xmltooling.dst2_1.ref.ModifyResponse;
import org.openliberty.xmltooling.dst2_1.ref.NewData;
import org.openliberty.xmltooling.dst2_1.ref.Query;
import org.openliberty.xmltooling.dst2_1.ref.QueryItem;
import org.openliberty.xmltooling.dst2_1.ref.QueryResponse;
import org.openliberty.xmltooling.dst2_1.ref.Select;
import org.openliberty.xmltooling.pp.AddressCard;
import org.openliberty.xmltooling.pp.AltID;
import org.openliberty.xmltooling.pp.MsgContact;
import org.openliberty.xmltooling.pp.MsgTechnology;
import org.openliberty.xmltooling.pp.dst2_1.ct.AddrType;
import org.openliberty.xmltooling.pp.dst2_1.ct.IDType;
import org.openliberty.xmltooling.pp.dst2_1.ct.MsgMethod;
import org.openliberty.xmltooling.pp.dst2_1.ct.MsgType;
import org.openliberty.xmltooling.soap.soap11.BodyBuilder;
import org.openliberty.xmltooling.utility_2_0.Status;
import org.openliberty.xmltooling.wsa.EndpointReference;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.soap.soap11.Body;

public class PersonalProfileService
extends BaseServiceClient {
    private static Logger log = Logger.getLogger(PersonalProfileService.class);
    public static final String SERVICE_URN = DiscoveryService.WSFServiceType.PERSONAL_PROFILE_SERVICE.getUrn();
    public static final String OPTION_MULTIPLE_MODIFY_ITEM = "urn:liberty:dst:multipleModification";
    public static final String OPTION_SUPPORTS_EXTENSIONS = "urn:liberty:dst:can:extend";
    public static final String OPTION_SUPPORTS_FULL_XPATH = "urn:liberty:dst fullXPath";
    public static final String DST_QUERY_SUFFIX = ":dst-2.1:Query";
    public static final String DST_MODIFY_SUFFIX = ":dst-2.1:Modify";

    public PersonalProfileService(DiscoveryService discoveryService, EndpointReference initialEndpointReference) {
        super(discoveryService, initialEndpointReference);
    }

    public static PersonalProfileService personalProfileServiceForEndpointReference(DiscoveryService discoveryService, EndpointReference epr) {
        PersonalProfileService pp = new PersonalProfileService(discoveryService, epr);
        return pp;
    }

    public boolean serviceExplicitlySupportsFullXPath() {
        return this.serviceExplicitlySupportsOption(OPTION_SUPPORTS_FULL_XPATH);
    }

    public boolean serviceExplicitlySupportsExtensions() {
        return this.serviceExplicitlySupportsOption(OPTION_SUPPORTS_EXTENSIONS);
    }

    public boolean serviceExplicitlySupportsMultipleModifyItems() {
        return this.serviceExplicitlySupportsOption(OPTION_MULTIPLE_MODIFY_ITEM);
    }

    public boolean serviceExplicitlySupportsDataQueryOption(DataQueryOption option) {
        return this.serviceExplicitlySupportsOption(option.keyword);
    }

    public boolean serviceExplicitlySupportsDataModifyOption(DataModifyOption option) {
        return this.serviceExplicitlySupportsOption(option.keyword);
    }

    public ModifyItem modifyItemForXPathAndObject(String xPathModifySelector, XMLObject modifiedObject) {
        DefaultBuilder builder2 = new DefaultBuilder();
        ModifyItem modifyItem = new ModifyItem(Konstantz.PP_NS, "Modification", "pp");
        modifyItem.getModifyItemAttributes().setOverrideAllowed(true, modifyItem);
        Select select = (Select)builder2.buildObject(Konstantz.PP_NS, "Select", "pp");
        select.setValue(xPathModifySelector);
        NewData newData = (NewData)builder2.buildObject(Konstantz.PP_NS, "NewData", "pp");
        newData.getUnknownXMLObjects().add(modifiedObject);
        modifyItem.setSelect(select);
        modifyItem.setNewData(newData);
        return modifyItem;
    }

    public boolean invokeModify(String xPathModifySelector, XMLObject modifiedObject) {
        ModifyItem modifyItem = this.modifyItemForXPathAndObject(xPathModifySelector, modifiedObject);
        modifyItem.getModifyItemAttributes().setOverrideAllowed(true, modifyItem);
        ArrayList<ModifyItem> modifyItems = new ArrayList<ModifyItem>();
        modifyItems.add(modifyItem);
        ModifyResponse modifyResponse = this.invokeModifyForModifyItems(modifyItems);
        if (null != modifyResponse) {
            Status status = modifyResponse.getStatus();
            if (status.isOK()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Update of \"" + xPathModifySelector + "\" succeeded"));
                }
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Update of \"" + xPathModifySelector + "\" failed"));
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Personal Profile Service failed to be invoked for Modify");
        }
        return false;
    }

    public ModifyResponse invokeModifyForModifyItems(List<ModifyItem> modifyItems) {
        DefaultBuilder builder2 = new DefaultBuilder();
        Modify modify = (Modify)builder2.buildObject(Konstantz.PP_NS, "Modify", "pp");
        modify.getModifyItems().addAll(modifyItems);
        WSFMessage message = null;
        try {
            message = WSFMessage.createWSFMessage(this, SERVICE_URN + DST_MODIFY_SUFFIX);
            Body body = new BodyBuilder().buildObject();
            body.getUnknownXMLObjects().add(modify);
            message.getRequestEnvelope().setBody(body);
            try {
                message.invoke();
                Body responseBody = message.getResponseEnvelope().getBody();
                for (XMLObject object : responseBody.getUnknownXMLObjects()) {
                    if (!(object instanceof ModifyResponse)) continue;
                    return (ModifyResponse)object;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No ModifyResponse element found in the body of the response Envelope");
                }
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.error((Object)"Exception while attempting to invoke a WSFMessage", (Throwable)e);
                }
            }
        }
        catch (XMLParserException e1) {
            e1.printStackTrace();
        }
        catch (UnmarshallingException e1) {
            e1.printStackTrace();
        }
        return null;
    }

    public AltID altIdForIDType(IDType.Type iDType) {
        return this.altIdForIDTypeURI(iDType.uri());
    }

    public AltID altIdForIDTypeURI(String iDTypeURI) {
        QueryItem queryItem = this.queryItemForAltIdByIDType(iDTypeURI, null);
        QueryResponse queryResponse = this.invokeQueryForQueryItem(queryItem);
        if (null != queryResponse) {
            Status status = queryResponse.getStatus();
            if (status.isFailed()) {
                XMLObjectChildrenList<Data> datas = queryResponse.getDatas();
                if (datas.size() > 0) {
                    for (XMLObject object : ((Data)((Object)datas.get(0))).getUnknownXMLObjects()) {
                        if (!(object instanceof AltID)) continue;
                        return (AltID)object;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("No AltID element returned for the IDType query: " + iDTypeURI));
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("No Data Elements returned for the IDType query: " + iDTypeURI));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Status: Failed for the IDType query: " + iDTypeURI));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"No QueryResponse returned. Service invocation failed.");
        }
        return null;
    }

    public MsgContact msgContactForID(String id) {
        QueryItem queryItem = this.queryItemForMsgContactID(id, null);
        List<MsgContact> msgContacts = this.msgContactsForQueryItem(queryItem);
        if (msgContacts.size() > 0) {
            return msgContacts.get(0);
        }
        return null;
    }

    public List<MsgContact> msgContactsForSpecifics(MsgTechnology.Technology technology, MsgMethod.Method method, MsgType.Type type) {
        QueryItem queryItem = this.queryItemForMsgContactSpecifics(technology, method, type, null);
        return this.msgContactsForQueryItem(queryItem);
    }

    public List<MsgContact> msgContactsForSpecifics(String technologyUri, String methodUri, String typeUri) {
        QueryItem queryItem = this.queryItemForMsgContactSpecifics(technologyUri, methodUri, typeUri, null);
        return this.msgContactsForQueryItem(queryItem);
    }

    public List<MsgContact> msgContactsForNickName(String nickname, boolean localScriptVersion) {
        QueryItem queryItem = this.queryItemForMsgContactNickName(nickname, localScriptVersion, null);
        return this.msgContactsForQueryItem(queryItem);
    }

    private List<MsgContact> msgContactsForQueryItem(QueryItem queryItem) {
        LinkedList<MsgContact> msgContacts = new LinkedList<MsgContact>();
        QueryResponse queryResponse = this.invokeQueryForQueryItem(queryItem);
        if (null != queryResponse) {
            Status status = queryResponse.getStatus();
            if (status.isOK()) {
                XMLObjectChildrenList<Data> datas = queryResponse.getDatas();
                if (datas.size() > 0) {
                    Data data = (Data)((Object)datas.get(0));
                    List<XMLObject> objects = data.getUnknownXMLObjects();
                    for (XMLObject object : objects) {
                        if (!(object instanceof MsgContact)) continue;
                        msgContacts.add((MsgContact)object);
                    }
                    if (log.isDebugEnabled() && msgContacts.size() == 0) {
                        log.debug((Object)("No MsgContact elements returned for the query: " + queryItem.getSelect().getValue()));
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("No Data Elements returned for the query: " + queryItem.getSelect().getValue()));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Status: Failed for the query: " + queryItem.getSelect().getValue()));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"No QueryResponse returned. Service invocation failed.");
        }
        return msgContacts;
    }

    public AddressCard addressCardForID(String id) {
        QueryItem queryItem = this.queryItemForAddressCardID(id, null);
        QueryResponse queryResponse = this.invokeQueryForQueryItem(queryItem);
        if (null != queryResponse) {
            Status status = queryResponse.getStatus();
            if (status.isOK()) {
                XMLObjectChildrenList<Data> datas = queryResponse.getDatas();
                if (datas.size() > 0) {
                    for (XMLObject object : ((Data)((Object)datas.get(0))).getUnknownXMLObjects()) {
                        if (!(object instanceof AddressCard)) continue;
                        return (AddressCard)object;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("No AddressCard element returned for the id: " + id));
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("No Data Elements returned for the AddressCard id query: " + id));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Status: Failed for the AddressCard id query: " + id));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"No QueryResponse returned. Service invocation failed.");
        }
        return null;
    }

    public List<AddressCard> addressCardsForAddressType(AddrType.Type addressType) {
        return this.addressCardsForQueryString(addressType.queryString());
    }

    public List<AddressCard> addressCardsForNickName(String nickname, boolean localScriptVersion) {
        StringBuffer queryBuffer = new StringBuffer("/pp:PP/pp:AddressCard [pp:");
        queryBuffer.append(localScriptVersion ? "LNick=\"" : "Nick=\"");
        queryBuffer.append(StringEscapeUtils.escapeXml((String)nickname)).append("\"]");
        return this.addressCardsForQueryString(queryBuffer.toString());
    }

    private List<AddressCard> addressCardsForQueryString(String queryString) {
        LinkedList<AddressCard> addressCards = new LinkedList<AddressCard>();
        QueryResponse queryResponse = this.invokeQuery(queryString);
        if (null != queryResponse) {
            Status status = queryResponse.getStatus();
            if (status.isOK()) {
                XMLObjectChildrenList<Data> datas = queryResponse.getDatas();
                if (datas.size() > 0) {
                    Data data = (Data)((Object)datas.get(0));
                    List<XMLObject> objects = data.getUnknownXMLObjects();
                    for (XMLObject object : objects) {
                        if (!(object instanceof AddressCard)) continue;
                        addressCards.add((AddressCard)object);
                    }
                    if (log.isDebugEnabled() && addressCards.size() == 0) {
                        log.debug((Object)("No AddressCard elements returned for the query: " + queryString));
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("No Data Elements returned for the query: " + queryString));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Status: Failed for the query: " + queryString));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"No QueryResponse returned. Service invocation failed.");
        }
        return addressCards;
    }

    public QueryItem queryItemForMsgContactID(String id, String itemID) {
        StringBuffer queryBuffer = new StringBuffer("/pp:PP/pp:MsgContact [@id=\"");
        queryBuffer.append(id).append("\"]");
        return this.queryItemForString(queryBuffer.toString(), itemID);
    }

    public QueryItem queryItemForMsgContactNickName(String nickname, boolean localScriptVersion, String itemID) {
        StringBuffer queryBuffer = new StringBuffer("/pp:PP/pp:MsgContact [pp:");
        queryBuffer.append(localScriptVersion ? "LNick=\"" : "Nick=\"");
        queryBuffer.append(StringEscapeUtils.escapeXml((String)nickname)).append("\"]");
        return this.queryItemForString(queryBuffer.toString(), itemID);
    }

    public QueryItem queryItemForMsgContactSpecifics(String technologyUri, String methodUri, String typeUri, String itemID) {
        StringBuffer queryBuffer = new StringBuffer("");
        if (null != technologyUri) {
            queryBuffer.append("pp:MsgTechnology=\"").append(StringEscapeUtils.escapeXml((String)technologyUri)).append("\"");
        }
        if (null != methodUri) {
            if (queryBuffer.length() > 0) {
                queryBuffer.append(" AND ");
            }
            queryBuffer.append("pp:MsgMethod=\"").append(StringEscapeUtils.escapeXml((String)methodUri)).append("\"");
        }
        if (null != typeUri) {
            if (queryBuffer.length() > 0) {
                queryBuffer.append(" AND ");
            }
            queryBuffer.append("pp:MsgType=\"").append(StringEscapeUtils.escapeXml((String)typeUri)).append("\"");
        }
        if (queryBuffer.length() == 0) {
            return null;
        }
        queryBuffer.insert(0, "/pp:PP/pp:MsgContact [").append("]");
        return this.queryItemForString(queryBuffer.toString(), itemID);
    }

    public QueryItem queryItemForMsgContactSpecifics(MsgTechnology.Technology technology, MsgMethod.Method method, MsgType.Type type, String itemID) {
        String technologyUri = null;
        String methodUri = null;
        String typeUri = null;
        if (null != technology) {
            technologyUri = technology.uri();
        }
        if (null != method) {
            methodUri = method.uri();
        }
        if (null != type) {
            typeUri = type.uri();
        }
        return this.queryItemForMsgContactSpecifics(technologyUri, methodUri, typeUri, itemID);
    }

    public QueryItem queryItemForAddressCardID(String id, String itemID) {
        StringBuffer queryBuffer = new StringBuffer("/pp:PP/pp:AddressCard [@id=\"");
        queryBuffer.append(id).append("\"]");
        return this.queryItemForString(queryBuffer.toString(), itemID);
    }

    public QueryItem queryItemForXPathQuery(String xpathQueryString, String itemID) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        try {
            xpath.compile(xpathQueryString);
            return this.queryItemForString(xpathQueryString, itemID);
        }
        catch (XPathExpressionException e) {
            log.error((Object)e.toString(), (Throwable)e);
            return null;
        }
    }

    public QueryItem queryItemForAltIdByIDType(String iDType, String itemID) {
        StringBuffer queryBuffer = new StringBuffer("/pp:PP/pp:LegalIdentity/pp:AltID [pp:IDType=\"");
        queryBuffer.append(iDType).append("\"]");
        return this.queryItemForString(queryBuffer.toString(), itemID);
    }

    public QueryItem queryItemForString(String properlyFormedQueryString, String itemID) {
        DefaultBuilder builder2 = new DefaultBuilder();
        QueryItem queryItem = (QueryItem)builder2.buildObject(Konstantz.PP_NS, QueryItem.LOCAL_NAME, "pp");
        if (null != itemID) {
            queryItem.setItemID(itemID);
        }
        Select select = (Select)builder2.buildObject(Konstantz.PP_NS, "Select", "pp");
        select.setValue(properlyFormedQueryString);
        queryItem.setSelect(select);
        return queryItem;
    }

    public List<XMLObject> profileObjectsForXPathQuery(String xpathQueryString) {
        LinkedList<XMLObject> results = new LinkedList<XMLObject>();
        QueryItem queryItem = this.queryItemForXPathQuery(xpathQueryString, null);
        if (null != queryItem) {
            QueryResponse queryResponse = this.invokeQueryForQueryItem(queryItem);
            if (null != queryResponse) {
                log.debug((Object)"QueryResponse Found");
                Status status = queryResponse.getStatus();
                if (status.isOK()) {
                    XMLObjectChildrenList<Data> datas = queryResponse.getDatas();
                    if (datas.size() > 0) {
                        Data data = (Data)((Object)datas.get(0));
                        results.addAll(data.getUnknownXMLObjects());
                        if (log.isDebugEnabled() && results.size() == 0) {
                            log.debug((Object)("No elements returned inside of Data for the query: " + xpathQueryString));
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)("No Data Elements returned for the query: " + xpathQueryString));
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("Status: Failed for the query: " + xpathQueryString));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"No QueryResponse returned. Service invocation failed.");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("A QueryItem could not be created from the specified query: " + xpathQueryString));
        }
        return results;
    }

    public QueryResponse invokeQuery(String queryItemSelect) {
        if (log.isDebugEnabled()) {
            log.debug((Object)queryItemSelect);
        }
        DefaultBuilder builder2 = new DefaultBuilder();
        QueryItem queryItem = (QueryItem)builder2.buildObject(Konstantz.PP_NS, QueryItem.LOCAL_NAME, "pp");
        Select select = (Select)builder2.buildObject(Konstantz.PP_NS, "Select", "pp");
        select.setValue(queryItemSelect);
        queryItem.setSelect(select);
        return this.invokeQueryForQueryItem(queryItem);
    }

    public QueryResponse invokeQueryForQueryItem(QueryItem queryItem) {
        ArrayList<QueryItem> queryItems = new ArrayList<QueryItem>();
        queryItems.add(queryItem);
        return this.invokeQueryForQueryItems(queryItems);
    }

    public QueryResponse invokeQueryForQueryItems(List<QueryItem> queryItems) {
        DefaultBuilder builder2 = new DefaultBuilder();
        Query query = (Query)builder2.buildObject(Konstantz.PP_NS, "Query", "pp");
        query.getQueryItems().addAll(queryItems);
        WSFMessage queryMessage = null;
        try {
            queryMessage = WSFMessage.createWSFMessage(this, SERVICE_URN + DST_QUERY_SUFFIX);
            Body body = new BodyBuilder().buildObject();
            body.getUnknownXMLObjects().add(query);
            queryMessage.getRequestEnvelope().setBody(body);
            try {
                queryMessage.invoke();
                Body responseBody = queryMessage.getResponseEnvelope().getBody();
                for (XMLObject object : responseBody.getUnknownXMLObjects()) {
                    if (!(object instanceof QueryResponse)) continue;
                    return (QueryResponse)object;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No QueryResponse element found in the body of the response Envelope");
                }
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.error((Object)"Exception while attempting to invoke a WSFMessage", (Throwable)e);
                }
            }
        }
        catch (XMLParserException e1) {
            e1.printStackTrace();
        }
        catch (UnmarshallingException e1) {
            e1.printStackTrace();
        }
        return null;
    }

    public static enum DataModifyOption {
        PP("urn:liberty:id-sis-pp:can", new String[]{"/pp:PP"}, "Can store some ID-SIS-PP data"),
        DOMOCILE("urn:liberty:id-sis-pp:can:domicile", new String[]{"/pp:PP/pp:AddressCard [pp:AddrType=\"urn:liberty:id-sis-pp:addrType:domicile\"]"}, "Can store some address card data corresponding to the domicile"),
        HOME("urn:liberty:id-sis-pp:can:home", new String[]{"/pp:PP/pp:AddressCard [pp:AddrType=\"urn:liberty:id-sis-pp:addrType:home\"]"}, "Can store some address card data corresponding to the home address"),
        WORK("urn:liberty:id-sis-pp:can:work", new String[]{"/pp:PP/pp:AddressCard [pp:AddrType=\"urn:liberty:id-sis-pp:addrType:work\"]", "/pp:PP/pp:MsgContact [pp:MsgType=\"urn:liberty:id-sis-pp:msgType:work\"]"}, "Can store some address card or messaging contact data corresponding to the office address "),
        PERSONAL("urn:liberty:id-sis-pp:can:personal", new String[]{"/pp:PP/pp:MsgContact [pp:MsgType=\"urn:liberty:id-sis-pp:msgType:personal\"]"}, "Can store some messaging contact data corresponding to personal contact "),
        MOBILE("urn:liberty:id-sis-pp:can:mobile", new String[]{"/pp:PP/pp:MsgContact [pp:MsgType=\"urn:liberty:id-sis-pp:msgType:mobile\"]"}, "Can store some messaging contact data for mobile contact "),
        VACATION("urn:liberty:id-sis-pp:can:vacation", new String[]{"/pp:PP/pp:MsgContact [pp:MsgType=\"urn:liberty:id-sis-pp:msgType:vacation\"]", "/pp:PP/pp:AddressCard [pp:AddrType=\"urn:liberty:id-sis-pp:addrType:vacation\"]"}, "Can store some messaging contact or address data for vacation contact "),
        ADDRESS("urn:liberty:id-sis-pp:can:address", new String[]{"/pp:PP/pp:AddressCard"}, "Can store some address card data "),
        COMMON_NAME("urn:liberty:id-sis-pp:can:cn", new String[]{"/pp:PP/pp:CommonName"}, "Can store some common name data "),
        INFORMAL_NAME("urn:liberty:id-sis-pp:can:informalName", new String[]{"/pp:PP/pp:InformalName", "/pp:PP/pp:LInformalName"}, "Can store informal name "),
        LEGAL_IDENTITY("urn:liberty:id-sis-pp:can:legal", new String[]{"/pp:PP/pp:LegalIdentity"}, "Can store some legal identity data "),
        EMPLOYMENT("urn:liberty:id-sis-pp:can:employment", new String[]{"/pp:PP/pp:EmploymentIdentity"}, "Can store some employment identity data "),
        FACADE("urn:liberty:id-sis-pp:can:facade", new String[]{"/pp:PP/pp:Facade"}, "Can store some facade data "),
        KEYS("urn:liberty:id-sis-pp:can:keys", new String[]{"/pp:PP/pp:SignKey", "/pp:PP/pp:EncryptKey"}, "Can store either or both keys "),
        DEMOGRAPHICS("urn:liberty:id-sis-pp:can:demographics", new String[]{"/pp:PP/pp:Demographics"}, "Can store some demographics data "),
        EMERGENCY("urn:liberty:id-sis-pp:can:emergency", new String[]{"/pp:PP/pp:EmergencyContact", "/pp:PP/pp:AddressCard [pp:AddrType=\"urn:liberty:id-sis-pp:addrType:emergency\"]"}, "Can store some emergency contact data ");

        private String keyword;
        private String[] equivalentXPaths;
        private String meaning;

        private DataModifyOption(String keyword, String[] equivalentXPaths, String meaning) {
            this.keyword = keyword;
            this.equivalentXPaths = equivalentXPaths;
            this.meaning = meaning;
        }

        public String keyword() {
            return this.keyword;
        }

        public String[] equivalentXPaths() {
            return this.equivalentXPaths;
        }

        public String meaning() {
            return this.meaning;
        }

        public DataModifyOption dataUpdateOptionForKeyword(String keyword) {
            if (null == keyword || keyword.trim().length() == 0 || 0 != keyword.indexOf("urn:liberty:id-sis-pp:can")) {
                return null;
            }
            for (DataModifyOption c : DataModifyOption.values()) {
                if (!c.keyword.equals(keyword)) continue;
                return c;
            }
            return null;
        }
    }

    public static enum DataQueryOption {
        PP("urn:liberty:id-sis-pp", new String[]{"/pp:PP"}, "Has some ID-SIS-PP data"),
        DOMOCILE("urn:liberty:id-sis-pp:domicile", new String[]{"/pp:PP/pp:AddressCard [pp:AddrType=\"urn:liberty:id-sis-pp:addrType:domicile\"]"}, "Has some address card data corresponding to the domicile"),
        HOME("urn:liberty:id-sis-pp:home", new String[]{"/pp:PP/pp:AddressCard [pp:AddrType=\"urn:liberty:id-sis-pp:addrType:home\"]"}, "Has some address card data corresponding to the home address"),
        WORK("urn:liberty:id-sis-pp:work", new String[]{"/pp:PP/pp:AddressCard [pp:AddrType=\"urn:liberty:id-sis-pp:addrType:work\"]", "/pp:PP/pp:MsgContact [pp:MsgType=\"urn:liberty:id-sis-pp:msgType:work\"]"}, "Has some address card or messaging contact data corresponding to the office address "),
        PERSONAL("urn:liberty:id-sis-pp:personal", new String[]{"/pp:PP/pp:MsgContact [pp:MsgType=\"urn:liberty:id-sis-pp:msgType:personal\"]"}, "Has some messaging contact data corresponding to personal contact "),
        MOBILE("urn:liberty:id-sis-pp:mobile", new String[]{"/pp:PP/pp:MsgContact [pp:MsgType=\"urn:liberty:id-sis-pp:msgType:mobile\"]"}, "Has some messaging contact data for mobile contact "),
        VACATION("urn:liberty:id-sis-pp:vacation", new String[]{"/pp:PP/pp:MsgContact [pp:MsgType=\"urn:liberty:id-sis-pp:msgType:vacation\"]", "/pp:PP/pp:AddressCard [pp:AddrType=\"urn:liberty:id-sis-pp:addrType:vacation\"]"}, "Has some messaging contact or address data for vacation contact "),
        ADDRESS("urn:liberty:id-sis-pp:address", new String[]{"/pp:PP/pp:AddressCard"}, "Has some address card data "),
        COMMON_NAME("urn:liberty:id-sis-pp:cn", new String[]{"/pp:PP/pp:CommonName"}, "Has some common name data "),
        INFORMAL_NAME("urn:liberty:id-sis-pp:informalName", new String[]{"/pp:PP/pp:InformalName", "/pp:PP/pp:LInformalName"}, "Has informal name "),
        LEGAL_IDENTITY("urn:liberty:id-sis-pp:legal", new String[]{"/pp:PP/pp:LegalIdentity"}, "Has some legal identity data "),
        EMPLOYMENT("urn:liberty:id-sis-pp:employment", new String[]{"/pp:PP/pp:EmploymentIdentity"}, "Has some employment identity data "),
        FACADE("urn:liberty:id-sis-pp:facade", new String[]{"/pp:PP/pp:Facade"}, "Has some facade data "),
        KEYS("urn:liberty:id-sis-pp:keys", new String[]{"/pp:PP/pp:SignKey", "/pp:PP/pp:EncryptKey"}, "Has either or both keys "),
        DEMOGRAPHICS("urn:liberty:id-sis-pp:demographics", new String[]{"/pp:PP/pp:Demographics"}, "Has some demographics data "),
        EMERGENCY("urn:liberty:id-sis-pp:emergency", new String[]{"/pp:PP/pp:EmergencyContact", "/pp:PP/pp:AddressCard [pp:AddrType=\"urn:liberty:id-sis-pp:addrType:emergency\"]"}, "Has some emergency contact data ");

        private String keyword;
        private String[] equivalentXPaths;
        private String meaning;

        private DataQueryOption(String keyword, String[] equivalentXPaths, String meaning) {
            this.keyword = keyword;
            this.equivalentXPaths = equivalentXPaths;
            this.meaning = meaning;
        }

        public String keyword() {
            return this.keyword;
        }

        public String[] equivalentXPaths() {
            return this.equivalentXPaths;
        }

        public String meaning() {
            return this.meaning;
        }

        public DataQueryOption dataAvailabilityOptionForKeyword(String keyword) {
            if (null == keyword || keyword.trim().length() == 0 || 0 != keyword.indexOf("urn:liberty:id-sis-pp")) {
                return null;
            }
            for (DataQueryOption c : DataQueryOption.values()) {
                if (!c.keyword.equals(keyword)) continue;
                return c;
            }
            return null;
        }
    }
}

