/*
 * Decompiled with CFR 0.152.
 */
package org.openliberty.wsc;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.QNameSupport;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.joda.time.DateTime;
import org.openliberty.wsc.AuthenticationService;
import org.openliberty.wsc.BaseServiceClient;
import org.openliberty.wsc.DiscoveryService;
import org.openliberty.wsc.OpenLibertyBootstrap;
import org.openliberty.wsc.SSLUtilities;
import org.openliberty.wsc.WSCException;
import org.openliberty.wsc.WSCUtilities;
import org.openliberty.wsc.WSFMessageSigner;
import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.openliberty.xmltooling.disco.SecurityContext;
import org.openliberty.xmltooling.disco.SecurityMechID;
import org.openliberty.xmltooling.security.Token;
import org.openliberty.xmltooling.soap.soap11.HeaderBuilder;
import org.openliberty.xmltooling.soap.soap11.HeaderIDWSF;
import org.openliberty.xmltooling.soapbinding.EndpointUpdate;
import org.openliberty.xmltooling.soapbinding.Framework;
import org.openliberty.xmltooling.soapbinding.ProcessingContext;
import org.openliberty.xmltooling.soapbinding.RedirectRequest;
import org.openliberty.xmltooling.soapbinding.Sender;
import org.openliberty.xmltooling.utility_2_0.Status;
import org.openliberty.xmltooling.wsa.Action;
import org.openliberty.xmltooling.wsa.Address;
import org.openliberty.xmltooling.wsa.CredentialsContext;
import org.openliberty.xmltooling.wsa.EndpointReference;
import org.openliberty.xmltooling.wsa.MessageID;
import org.openliberty.xmltooling.wsa.Metadata;
import org.openliberty.xmltooling.wsa.ReferenceParameters;
import org.openliberty.xmltooling.wsa.RelatesTo;
import org.openliberty.xmltooling.wsa.To;
import org.openliberty.xmltooling.wsse.Security;
import org.openliberty.xmltooling.wsse.SecurityBuilder;
import org.openliberty.xmltooling.wsu.Created;
import org.openliberty.xmltooling.wsu.CreatedBuilder;
import org.openliberty.xmltooling.wsu.Timestamp;
import org.openliberty.xmltooling.wsu.TimestampBuilder;
import org.opensaml.core.xml.AttributeExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.XMLRuntimeException;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallerFactory;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.soap.soap11.Detail;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Fault;
import org.opensaml.soap.soap11.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSFMessage {
    protected static Logger log = LoggerFactory.getLogger(WSFMessage.class);
    protected static BasicParserPool parser;
    protected static MarshallerFactory marshallerFactory;
    protected static UnmarshallerFactory unmarshallerFactory;
    protected static XMLObjectBuilderFactory builderFactory;
    private BaseServiceClient serviceClient;
    private Envelope envelope;
    private String response;
    private Envelope responseEnvelope;
    private String actionString;
    private List<String> signatureIds;
    private RedirectRequest redirectRequest = null;
    private boolean endpointUpdated = false;
    private static boolean debugJustSOAPBody;

    public void addWSUIdAttribute(AttributeExtensibleXMLObject obj, String id) {
        this.getSignatureIds().add(id);
        obj.getUnknownAttributes().put(QNameSupport.constructQName((String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", (String)"Id", (String)"wsu"), id);
    }

    public void addSOAP11Attributes(AttributeExtensibleXMLObject obj, boolean mustUnderstand) {
        AttributeMap atts = obj.getUnknownAttributes();
        atts.put(QNameSupport.constructQName((String)"http://schemas.xmlsoap.org/soap/envelope/", (String)"mustUnderstand", (String)"soap11"), mustUnderstand ? "1" : "0");
        atts.put(QNameSupport.constructQName((String)"http://schemas.xmlsoap.org/soap/envelope/", (String)"actor", (String)"soap11"), Konstantz.SOAP_ACTOR);
    }

    private WSFMessage(BaseServiceClient serviceClient) {
        this.serviceClient = serviceClient;
    }

    public static WSFMessage createWSFMessage(BaseServiceClient serviceClient, String actionString) throws XMLParserException, UnmarshallingException {
        WSFMessage message = new WSFMessage(serviceClient);
        message.actionString = actionString;
        message.initializeRequestEnvelope();
        return message;
    }

    public static void setDebugJustSOAPBody(boolean _debugJustSOAPBody) {
        debugJustSOAPBody = _debugJustSOAPBody;
    }

    public static boolean getDebugJustSOAPBody() {
        return debugJustSOAPBody;
    }

    private void initializeRequestEnvelope() throws XMLParserException, UnmarshallingException {
        SecurityContext securityContext;
        XMLObjectChildrenList<SecurityContext> securityContexts;
        EndpointReference epr = this.serviceClient.getServiceEndpointReference();
        String destinationUrl = epr.getAddress().getValue();
        Envelope envelope = null;
        envelope = WSFMessage.buildSOAPEnvelope();
        this.addWSUIdAttribute((AttributeExtensibleXMLObject)envelope.getBody(), "body");
        HeaderIDWSF header = new HeaderBuilder().buildObject();
        Framework fw = new Framework();
        fw.setVersion("2.0");
        this.addSOAP11Attributes(fw, true);
        this.addWSUIdAttribute(fw, "fwkHdr");
        header.setFramework(fw);
        To to = new To();
        to.setValue(destinationUrl);
        this.addWSUIdAttribute(to, "toHdr");
        header.setTo(to);
        String providerID = OpenLibertyBootstrap.getProviderIDUri();
        if (null != providerID && providerID.trim().length() > 0) {
            Sender sender = new Sender();
            sender.setProviderID(providerID);
            this.addWSUIdAttribute(sender, "sndrHdr");
            header.setSender(sender);
        }
        if (null != this.actionString) {
            Action action = new Action();
            action.setValue(this.actionString);
            this.addWSUIdAttribute(action, "actHdr");
            header.setAction(action);
        }
        MessageID messageID = new MessageID();
        this.addWSUIdAttribute(messageID, "midHdr");
        header.setMessageID(messageID);
        Created created = new CreatedBuilder().buildObject();
        created.setValue(OpenLibertyHelpers.stringForDateTime(new DateTime()));
        Timestamp ts = new TimestampBuilder().buildObject();
        ts.setCreated(created);
        this.addWSUIdAttribute(ts, "tsSecHdr");
        Security security = new SecurityBuilder().buildObject();
        this.addSOAP11Attributes(security, true);
        security.getUnknownXMLObjects().add((XMLObject)ts);
        header.setSecurity(security);
        Metadata metaData = epr.getMetadata();
        if (null != metaData && (securityContexts = metaData.getSecurityContexts()).size() > 0 && null != (securityContext = (SecurityContext)securityContexts.get(0))) {
            if (null != securityContext.getUnknownXMLObjects()) {
                for (XMLObject obj : securityContext.getUnknownXMLObjects()) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug(obj.getElementQName().toString());
                }
            }
            if (null != securityContext.getTokens() && securityContext.getTokens().size() > 0) {
                Token token = securityContext.getTokens().get(0);
                EncryptedAssertion encryptedAssertion = token.getEncryptedAssertion();
                if (null != encryptedAssertion) {
                    security.getUnknownXMLObjects().add((XMLObject)encryptedAssertion);
                } else {
                    Assertion saml2Assertion = (Assertion)OpenLibertyHelpers.cloneXMLObject((XMLObject)token.getAssertion());
                    if (null != saml2Assertion) {
                        this.getSignatureIds().add(saml2Assertion.getID());
                        saml2Assertion.releaseDOM();
                        saml2Assertion.releaseChildrenDOM(true);
                        security.getUnknownXMLObjects().add((XMLObject)saml2Assertion);
                    } else {
                        security.setValue(token.getValue());
                    }
                }
            }
        }
        envelope.setHeader((Header)header);
        this.setRequestEnvelope(envelope);
    }

    public List<String> getSignatureIds() {
        if (null == this.signatureIds) {
            this.signatureIds = new ArrayList<String>();
        }
        return this.signatureIds;
    }

    protected BaseServiceClient getServiceClient() {
        return this.serviceClient;
    }

    protected void setServiceClient(BaseServiceClient serviceClient) {
        this.serviceClient = serviceClient;
    }

    public void setHeaderProcessingContext(ProcessingContext processingContext) {
        HeaderIDWSF header = (HeaderIDWSF)this.envelope.getHeader();
        for (XMLObject obj : header.getUnknownXMLObjects()) {
            if (!(obj instanceof ProcessingContext)) continue;
            header.getUnknownXMLObjects().remove(obj);
            break;
        }
        if (null != processingContext) {
            this.addWSUIdAttribute(processingContext, "pcHdr");
            this.addSOAP11Attributes(processingContext, true);
            header.getUnknownXMLObjects().add(processingContext);
        }
    }

    public void invoke() throws IOException, MarshallingException, XMLParserException, UnmarshallingException, WSCException, GeneralSecurityException {
        this.handleRedirectRequestState();
        this.handleEndpointUpdatedState();
        HeaderIDWSF header = (HeaderIDWSF)this.envelope.getHeader();
        String to = header.getTo().getValue();
        Konstantz.WSFSecurityMechanism securityMechanism = Konstantz.WSFSecurityMechanism.ID_WSF20_TLS_BEARER;
        if (null != this.serviceClient.getServiceEndpointReference().getMetadata()) {
            SecurityMechID securityMechID = ((SecurityContext)this.serviceClient.getServiceEndpointReference().getMetadata().getSecurityContexts().get(0)).getSecurityMechIDs().get(0);
            securityMechanism = Konstantz.WSFSecurityMechanism.findSecurityMechanismForURI(securityMechID.getValue());
        }
        Element outgoingMessage = null;
        if (securityMechanism == Konstantz.WSFSecurityMechanism.ID_WSF20_CLIENT_TLS_SAML2 || securityMechanism == Konstantz.WSFSecurityMechanism.ID_WSF20_TLS_SAML2 || securityMechanism == Konstantz.WSFSecurityMechanism.ID_WSF20_NULL_SAML2) {
            WSFMessageSigner messageSigner = new WSFMessageSigner();
            try {
                outgoingMessage = messageSigner.sign(this);
                if (log.isDebugEnabled()) {
                    log.debug("\n\n#### SIGNED REQUEST MESSAGE ####################################################################");
                    log.debug(SerializeSupport.prettyPrintXML((Node)outgoingMessage));
                    log.debug("#### END SIGNED REQUEST MESSAGE ################################################################\n\n");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Marshaller em = XMLObjectSupport.getMarshaller((QName)Envelope.DEFAULT_ELEMENT_NAME);
            outgoingMessage = em.marshall((XMLObject)this.envelope);
            if (log.isDebugEnabled()) {
                if (debugJustSOAPBody) {
                    NodeList nl = outgoingMessage.getChildNodes();
                    log.debug(" REQUEST\n" + SerializeSupport.prettyPrintXML((Node)nl.item(1)) + "\n");
                } else {
                    log.debug(" REQUEST\n" + SerializeSupport.prettyPrintXML((Node)outgoingMessage) + "\n");
                }
            }
        }
        this.response = null;
        this.response = securityMechanism == Konstantz.WSFSecurityMechanism.ID_WSF20_CLIENT_TLS_SAML2 ? SSLUtilities.postSOAPMessage(to, outgoingMessage, true) : (securityMechanism == Konstantz.WSFSecurityMechanism.ID_WSF20_CLIENT_TLS_PEER_SAML2 ? SSLUtilities.postSOAPMessage(to, outgoingMessage, true) : (securityMechanism == Konstantz.WSFSecurityMechanism.ID_WSF20_NULL_NULL ? SSLUtilities.postSOAPMessageNOTLS(to, outgoingMessage) : SSLUtilities.postSOAPMessage(to, outgoingMessage, false)));
        this.processResponse(this.response);
    }

    private void processResponse(String responseString) throws XMLParserException, UnmarshallingException, WSCException, IOException, MarshallingException, GeneralSecurityException {
        Fault fault;
        Detail detail;
        Document responseDoc = parser.parse((Reader)new StringReader(responseString));
        if (log.isDebugEnabled()) {
            if (debugJustSOAPBody) {
                NodeList nl = responseDoc.getDocumentElement().getChildNodes();
                log.debug(" RESPONSE\n" + SerializeSupport.prettyPrintXML((Node)nl.item(1)) + "\n");
            } else {
                log.debug(" RESPONSE\n" + SerializeSupport.prettyPrintXML((Node)responseDoc.getDocumentElement()) + "\n");
            }
        }
        Element envelopeElem = responseDoc.getDocumentElement();
        Unmarshaller unmarshaller = XMLObjectSupport.getUnmarshaller((Element)envelopeElem);
        this.responseEnvelope = (Envelope)unmarshaller.unmarshall(envelopeElem);
        List faultList = this.responseEnvelope.getBody().getUnknownXMLObjects(Fault.TYPE_NAME);
        if (faultList.size() > 0 && (detail = (fault = (Fault)faultList.get(0)).getDetail()) != null) {
            String statusCode;
            List redirectRequestList = detail.getUnknownXMLObjects(RedirectRequest.LOCAL_Q_NAME);
            if (redirectRequestList.size() > 0) {
                this.redirectRequest = (RedirectRequest)((Object)redirectRequestList.get(0));
                return;
            }
            Status status = null;
            List statusList = detail.getUnknownXMLObjects(Status.LOCAL_Q_NAME);
            if (statusList.size() > 0 && null != (statusCode = (status = (Status)((Object)statusList.get(0))).getCode())) {
                if (statusCode.equals(Konstantz.Status.ENDPOINT_UPDATED.getCode())) {
                    if (this.processEndpointUpdated()) {
                        this.invoke();
                        return;
                    }
                } else if (statusCode.equals(Konstantz.Status.INAPPROPRIATE_CREDENTIALS.getCode()) && this.handleInappropriateCredentials()) {
                    this.invoke();
                    return;
                }
            }
        }
    }

    private boolean handleInappropriateCredentials() {
        HeaderIDWSF header = (HeaderIDWSF)this.responseEnvelope.getHeader();
        CredentialsContext credentialsContext = header.getCredentialsContext();
        if (null != credentialsContext) {
            List<EndpointReference> authEPRs;
            XMLObjectChildrenList<org.openliberty.xmltooling.soapbinding.SecurityMechID> securityMechIds = credentialsContext.getSecurityMechIDs();
            if (null != securityMechIds && securityMechIds.size() > 0) {
                String[] sechMechs = new String[securityMechIds.size()];
                for (int i = 0; i < sechMechs.length; ++i) {
                    sechMechs[i] = ((org.openliberty.xmltooling.soapbinding.SecurityMechID)((Object)securityMechIds.get(i))).getValue();
                }
                List<EndpointReference> eprs = WSCUtilities.queryDiscoveryServiceForServiceEPRs(this.serviceClient.getDiscoveryService(), new String[]{this.serviceClient.getServiceEndpointReference().getMetadata().getServiceTypes().get(0).getValue()}, new String[]{this.serviceClient.getServiceEndpointReference().getMetadata().getProviderID().getValue()}, sechMechs);
                if (null != eprs && eprs.size() < 0) {
                    this.serviceClient.replaceServiceEndpointReference(eprs.get(0));
                    return true;
                }
            } else if (null != credentialsContext.getRequestedAuthnContext() && null != OpenLibertyBootstrap.getAuthenticationServiceUrl() && null != (authEPRs = WSCUtilities.queryDiscoveryServiceForServiceEPRs(this.serviceClient.getDiscoveryService(), new String[]{DiscoveryService.WSFServiceType.AUTHENTICATION_SERVICE.getUrn()}, null, null)) && authEPRs.size() > 0) {
                AuthenticationService authService = (AuthenticationService)this.serviceClient.getDiscoveryService().serviceClientForTypeAndEndpointReference(DiscoveryService.WSFServiceType.AUTHENTICATION_SERVICE, authEPRs.get(0));
                try {
                    EndpointReference discoEPR = authService.authenticate(OpenLibertyBootstrap.getAuthUsername(), OpenLibertyBootstrap.getAuthPassword(), OpenLibertyBootstrap.getAuthMechanism(), credentialsContext.getRequestedAuthnContext());
                    DiscoveryService ds = new DiscoveryService(discoEPR);
                    List<EndpointReference> eprs = WSCUtilities.queryDiscoveryServiceForServiceEPRs(ds, new String[]{this.serviceClient.getServiceEndpointReference().getMetadata().getServiceTypes().get(0).getValue()}, null, null);
                    this.serviceClient.replaceServiceEndpointReference(eprs.get(0));
                    this.serviceClient.setDiscoveryService(ds);
                    return true;
                }
                catch (WSCException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    private boolean processEndpointUpdated() {
        HeaderIDWSF header = (HeaderIDWSF)this.responseEnvelope.getHeader();
        EndpointUpdate endpointUpdate = header.getEndpointUpdate();
        if (null != endpointUpdate) {
            if (endpointUpdate.getUpdateType() == EndpointUpdate.UpdateType.PARTIAL) {
                List<XMLObject> originalExtensions;
                List<XMLObject> updatedExtensions;
                Metadata originalMetadata;
                Metadata updatedMetadata;
                ReferenceParameters originalReferenceParameters;
                Address address;
                EndpointReference originalEPR = this.serviceClient.getServiceEndpointReference();
                try {
                    Marshaller m = marshallerFactory.getMarshaller((XMLObject)originalEPR);
                    Element originalEPRElement = m.marshall((XMLObject)originalEPR);
                    originalEPRElement = (Element)originalEPRElement.cloneNode(true);
                    Unmarshaller u = unmarshallerFactory.getUnmarshaller(originalEPRElement);
                    originalEPR = (EndpointReference)u.unmarshall(originalEPRElement);
                }
                catch (UnmarshallingException e) {
                    e.printStackTrace();
                }
                catch (MarshallingException e) {
                    e.printStackTrace();
                }
                EndpointReference newEPR = new EndpointReference();
                newEPR.setNotOnOrAfter(endpointUpdate.getNotOnOrAfter());
                if (endpointUpdate.isNoAddressChange()) {
                    address = new Address();
                    address.setValue(originalEPR.getAddress().getValue());
                    newEPR.setAddress(address);
                } else {
                    address = new Address();
                    address.setValue(endpointUpdate.getAddress().getValue());
                    newEPR.setAddress(address);
                }
                ReferenceParameters updatedReferenceParameters = endpointUpdate.getReferenceParameters();
                if (null != updatedReferenceParameters) {
                    updatedReferenceParameters.setParent((XMLObject)newEPR);
                    endpointUpdate.setReferenceParameters(null);
                    updatedReferenceParameters.setParent((XMLObject)newEPR);
                    newEPR.setReferenceParameters(updatedReferenceParameters);
                }
                if (null != (originalReferenceParameters = originalEPR.getReferenceParameters())) {
                    ReferenceParameters newEPRReferenceParameters = newEPR.getReferenceParameters();
                    if (null == newEPRReferenceParameters) {
                        newEPR.setReferenceParameters(originalReferenceParameters);
                    } else {
                        for (XMLObject obj : originalReferenceParameters.getOrderedChildren()) {
                            List parameters = newEPRReferenceParameters.getUnknownXMLObjects(obj.getElementQName());
                            if (parameters.size() != 0) continue;
                            newEPRReferenceParameters.getUnknownXMLObjects().add(obj);
                        }
                    }
                }
                if (null != (updatedMetadata = endpointUpdate.getMetadata())) {
                    updatedMetadata.setParent((XMLObject)newEPR);
                    endpointUpdate.setMetadata(null);
                    updatedMetadata.setParent((XMLObject)newEPR);
                    newEPR.setMetadata(updatedMetadata);
                }
                if (null != (originalMetadata = originalEPR.getMetadata())) {
                    Metadata newEPRMetadata = newEPR.getMetadata();
                    if (null == newEPRMetadata) {
                        newEPR.setMetadata(originalMetadata);
                    } else {
                        for (XMLObject obj : originalMetadata.getOrderedChildren()) {
                            List<XMLObject> entries = newEPRMetadata.getUnknownXMLObjects(obj.getElementQName());
                            if (entries.size() != 0) continue;
                            newEPRMetadata.getUnknownXMLObjects().add(obj);
                        }
                    }
                }
                if (null != (updatedExtensions = endpointUpdate.getUnknownXMLObjects())) {
                    endpointUpdate.getUnknownXMLObjects().removeAll(updatedExtensions);
                    for (XMLObject obj : updatedExtensions) {
                        obj.setParent((XMLObject)newEPR);
                        newEPR.getUnknownXMLObjects().add(obj);
                    }
                }
                if (null != (originalExtensions = originalEPR.getUnknownXMLObjects())) {
                    if (null == updatedExtensions) {
                        newEPR.getUnknownXMLObjects().addAll(originalExtensions);
                    } else {
                        for (XMLObject obj : originalExtensions) {
                            List<XMLObject> parameters = newEPR.getUnknownXMLObjects(obj.getElementQName());
                            if (parameters.size() != 0) continue;
                            newEPR.getUnknownXMLObjects().add(obj);
                        }
                    }
                }
                this.serviceClient.setServiceEndpointReference(newEPR);
                return true;
            }
            this.serviceClient.setServiceEndpointReference(endpointUpdate);
            return true;
        }
        return false;
    }

    private void handleEndpointUpdatedState() throws XMLParserException, UnmarshallingException {
        if (this.endpointUpdated) {
            this.initializeRequestEnvelope();
            this.endpointUpdated = false;
        }
    }

    private void handleRedirectRequestState() throws XMLParserException, UnmarshallingException {
        if (this.hasRedirectRequestBeenIssued()) {
            this.initializeRequestEnvelope();
            HeaderIDWSF header = (HeaderIDWSF)this.envelope.getHeader();
            RelatesTo relatesTo = new RelatesTo();
            relatesTo.setValue(((HeaderIDWSF)this.responseEnvelope.getHeader()).getMessageID().getValue());
            this.addSOAP11Attributes(relatesTo, true);
            this.addWSUIdAttribute(relatesTo, "relHdr");
            header.setRelatesTo(relatesTo);
            this.redirectRequest = null;
        }
    }

    public static String prettyPrintRequestMessage(WSFMessage message) {
        return OpenLibertyHelpers.prettyPrintXMLObject((XMLObject)message.getRequestEnvelope());
    }

    public static String prettyPrintResponseMessage(WSFMessage message) {
        return OpenLibertyHelpers.prettyPrintXMLObject((XMLObject)message.getResponseEnvelope());
    }

    public static Envelope buildSOAPEnvelope() throws XMLParserException, UnmarshallingException {
        Document soapDoc = parser.parse((Reader)new StringReader(Konstantz.EMPTY_SOAP_TEMPLATE));
        Element envelopeElem = soapDoc.getDocumentElement();
        Unmarshaller unmarshaller = XMLObjectSupport.getUnmarshaller((Element)envelopeElem);
        return (Envelope)unmarshaller.unmarshall(envelopeElem);
    }

    public Envelope getRequestEnvelope() {
        return this.envelope;
    }

    public void setRequestEnvelope(Envelope envelope) {
        this.envelope = envelope;
    }

    public Envelope getResponseEnvelope() {
        return this.responseEnvelope;
    }

    public void setResponseEnvelope(Envelope envelope) {
        this.responseEnvelope = envelope;
    }

    public String getResponseString() {
        return this.response;
    }

    public boolean hasRedirectRequestBeenIssued() {
        return null != this.redirectRequest;
    }

    public boolean hasUpdatedEndpointReference() {
        return this.endpointUpdated;
    }

    static {
        debugJustSOAPBody = false;
        parser = new BasicParserPool();
        parser.setNamespaceAware(true);
        try {
            parser.initialize();
        }
        catch (ComponentInitializationException e) {
            throw new XMLRuntimeException("Could not initialize BasicParserPool", (Exception)((Object)e));
        }
        marshallerFactory = XMLObjectProviderRegistrySupport.getMarshallerFactory();
        unmarshallerFactory = XMLObjectProviderRegistrySupport.getUnmarshallerFactory();
        builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
    }
}

