/*
 * Decompiled with CFR 0.152.
 */
package org.openliberty.xmltooling;

import com.google.common.base.Objects;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Scanner;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallerFactory;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OpenLibertyHelpers {
    private static Logger log = Logger.getLogger(OpenLibertyHelpers.class);
    public static String FALSE_STR = "0";
    public static String TRUE_STR = "1";
    private static String defaultDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static DateTimeFormatter defaultDateFormatter;
    protected static MarshallerFactory marshallerFactory;
    protected static UnmarshallerFactory unmarshallerFactory;
    protected static BasicParserPool parserPool;
    protected static XMLObjectBuilderFactory builderFactory;

    public static XMLObject createXMLObjectForQName(QName qname) {
        XMLObject object = null;
        XMLObjectBuilder builder2 = XMLObjectSupport.getBuilder((QName)qname);
        if (builder2 == null) {
            log.error((Object)("Unable to retrieve builder for object QName " + qname));
        } else {
            object = builder2.buildObject(qname.getNamespaceURI(), qname.getLocalPart(), qname.getPrefix());
        }
        return object;
    }

    public static String stringForDateTime(DateTime dateTime) {
        if (null != dateTime) {
            return OpenLibertyHelpers.getDefaultDateFormatter().print((ReadableInstant)dateTime);
        }
        return "";
    }

    public static DateTime dateTimeForString(String dateTimeString) {
        if (dateTimeString != null) {
            try {
                return OpenLibertyHelpers.getDefaultDateFormatter().parseDateTime(dateTimeString);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)e);
            }
        }
        return null;
    }

    public static Integer integerFromString(String integerString) {
        if (NumberUtils.isNumber((String)integerString)) {
            return NumberUtils.createInteger((String)integerString);
        }
        return null;
    }

    public static Integer positiveIntegerFromString(String integerString, Integer defaultValue) {
        Integer result;
        if (NumberUtils.isNumber((String)integerString) && (result = NumberUtils.createInteger((String)integerString)) > -1) {
            return result;
        }
        return defaultValue;
    }

    public static Boolean booleanFromString(String booleanString) {
        if (null != booleanString) {
            if ((booleanString = booleanString.toLowerCase()).equals(FALSE_STR) || booleanString.equals("false")) {
                return Boolean.FALSE;
            }
            if (booleanString.equals(TRUE_STR) || booleanString.equals("true")) {
                return Boolean.TRUE;
            }
        }
        return null;
    }

    public static String stringFromBoolean(Boolean b, String defaultString) {
        if (null == b) {
            return defaultString;
        }
        return b != false ? TRUE_STR : FALSE_STR;
    }

    public static String prepareForAssignment(String oldStringValue, String newStringValue, AbstractXMLObject abstractXMLObject) {
        String newString = StringSupport.trimOrNull((String)newStringValue);
        if (!Objects.equal((Object)oldStringValue, (Object)newString)) {
            abstractXMLObject.releaseThisandParentDOM();
        }
        return newString;
    }

    public static <T> T prepareForAssignment(T oldValue, T newValue, AbstractXMLObject abstractXMLObject) {
        if (!Objects.equal(oldValue, newValue)) {
            abstractXMLObject.releaseThisandParentDOM();
        }
        return newValue;
    }

    public static DateTime prepareForAssignment(DateTime oldValue, DateTime newValue, DateTimeFormatter formatter, AbstractXMLObject abstractXMLObject) {
        if (null != oldValue && null != newValue) {
            if (null != formatter) {
                if (!formatter.print((ReadableInstant)oldValue).equals(formatter.print((ReadableInstant)newValue))) {
                    abstractXMLObject.releaseThisandParentDOM();
                }
            } else if (0 != oldValue.compareTo((ReadableInstant)newValue)) {
                abstractXMLObject.releaseThisandParentDOM();
            }
        } else if (oldValue != newValue) {
            abstractXMLObject.releaseThisandParentDOM();
        }
        return newValue;
    }

    public static Integer prepareForAssignment(Integer oldValue, Integer newValue, AbstractXMLObject abstractXMLObject) {
        if (null != oldValue && null != newValue && newValue.intValue() != oldValue.intValue() || oldValue != newValue) {
            abstractXMLObject.releaseThisandParentDOM();
        }
        return newValue;
    }

    public static DateTimeFormatter getDefaultDateFormatter() {
        if (null == defaultDateFormatter) {
            DateTimeFormatter formatter = DateTimeFormat.forPattern((String)defaultDateFormat);
            defaultDateFormatter = formatter.withChronology((Chronology)ISOChronology.getInstanceUTC());
        }
        return defaultDateFormatter;
    }

    public static XMLObject cloneXMLObject(XMLObject xmlObject) {
        XMLObject clonedXMLObject = null;
        if (null != xmlObject) {
            try {
                Marshaller marshaller = marshallerFactory.getMarshaller(xmlObject);
                Element ele = marshaller.marshall(xmlObject);
                ele = (Element)ele.cloneNode(true);
                Unmarshaller u = unmarshallerFactory.getUnmarshaller(ele);
                clonedXMLObject = u.unmarshall(ele);
            }
            catch (UnmarshallingException e) {
                e.printStackTrace();
            }
            catch (MarshallingException e) {
                e.printStackTrace();
            }
        }
        return clonedXMLObject;
    }

    public static String prettyPrintXMLObject(XMLObject xmlObject) {
        if (null != xmlObject) {
            Marshaller m = marshallerFactory.getMarshaller(xmlObject);
            try {
                Element ele = m.marshall(xmlObject);
                return SerializeSupport.prettyPrintXML((Node)ele);
            }
            catch (MarshallingException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public static <E> E selectFromAList(E[] list, String name) {
        Scanner in = new Scanner(System.in);
        System.out.println("\n\n" + name + "\n");
        int i = 0;
        for (E obj : list) {
            System.out.println(" (" + i++ + ") " + obj.toString());
        }
        System.out.println(" (" + i++ + ") to select none\n");
        System.out.print(" $ ");
        int w = in.nextInt();
        if (w < 0 || w > list.length - 1) {
            return null;
        }
        return list[w];
    }

    public static XMLObject unmarshallElementFromString(String inputString) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(inputString.getBytes());
            if (null == is) {
                log.debug((Object)("Failed to create a stream from: " + inputString));
                return null;
            }
            Document doc = parserPool.parse((InputStream)is);
            Element ele = doc.getDocumentElement();
            Unmarshaller unmarshaller = XMLObjectSupport.getUnmarshaller((Element)ele);
            if (unmarshaller == null) {
                log.debug((Object)"Unable to retrieve unmarshaller by DOM Element");
                return null;
            }
            return unmarshaller.unmarshall(ele);
        }
        catch (XMLParserException e) {
            e.printStackTrace();
        }
        catch (UnmarshallingException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static XMLObject unmarshallElementFromFile(File elementFile) {
        try {
            FileInputStream is = new FileInputStream(elementFile);
            if (null == is) {
                log.debug((Object)("Input Stream is null. Unable to load " + elementFile.getPath()));
                return null;
            }
            Document doc = parserPool.parse((InputStream)is);
            Element ele = doc.getDocumentElement();
            Unmarshaller unmarshaller = XMLObjectSupport.getUnmarshaller((Element)ele);
            if (unmarshaller == null) {
                log.debug((Object)"Unable to retrieve unmarshaller by DOM Element");
                return null;
            }
            return unmarshaller.unmarshall(ele);
        }
        catch (XMLParserException e) {
            System.err.println("Unable to parse element file " + elementFile.getPath());
        }
        catch (UnmarshallingException e) {
            System.err.println("Unmarshalling failed when parsing element file " + elementFile.getPath() + ": " + (Object)((Object)e));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected static XMLObject unmarshallElementFromFile(String elementFileName) {
        try {
            InputStream is = OpenLibertyHelpers.class.getResourceAsStream(elementFileName);
            if (null == is) {
                log.debug((Object)("Input Stream is null. Unable to load " + elementFileName));
                return null;
            }
            Document doc = parserPool.parse(is);
            Element ele = doc.getDocumentElement();
            Unmarshaller unmarshaller = XMLObjectSupport.getUnmarshaller((Element)ele);
            if (unmarshaller == null) {
                log.debug((Object)"Unable to retrieve unmarshaller by DOM Element");
                return null;
            }
            return unmarshaller.unmarshall(ele);
        }
        catch (XMLParserException e) {
            System.err.println("Unable to parse element file " + elementFileName);
        }
        catch (UnmarshallingException e) {
            System.err.println("Unmarshalling failed when parsing element file " + elementFileName + ": " + (Object)((Object)e));
        }
        return null;
    }

    static {
        try {
            parserPool = new BasicParserPool();
            parserPool.setNamespaceAware(true);
            builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
            marshallerFactory = XMLObjectProviderRegistrySupport.getMarshallerFactory();
            unmarshallerFactory = XMLObjectProviderRegistrySupport.getUnmarshallerFactory();
        }
        catch (Exception e) {
            System.err.println("Can not initialize GeneralUtilities" + e);
            e.printStackTrace();
        }
    }
}

