/*
 * Decompiled with CFR 0.152.
 */
package org.openliberty.xmltooling.idsis.dap;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.openliberty.xmltooling.dst2_1.RequestType;
import org.openliberty.xmltooling.idsis.dap.DAPQueryItem;
import org.openliberty.xmltooling.idsis.dap.DAPSelect;
import org.openliberty.xmltooling.idsis.dap.DAPSubscription;
import org.openliberty.xmltooling.idsis.dap.DAPTestItem;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectChildrenList;

public class DAPQuery
extends RequestType {
    public static String LOCAL_NAME = "Query";
    private XMLObjectChildrenList<DAPTestItem> testItems;
    private XMLObjectChildrenList<DAPQueryItem> queryItems;
    private XMLObjectChildrenList<DAPSubscription> subscriptions;

    public DAPQuery() {
        super("urn:liberty:id-sis-dap:2006-02:dst-2.1", LOCAL_NAME, "dap");
    }

    public static DAPQuery entityQueryWithSelectAttributes(String selectAttributes, String itemId) {
        if (null == itemId) {
            itemId = UUID.randomUUID().toString();
        }
        DAPSelect select = new DAPSelect();
        select.setAttributes(selectAttributes);
        DAPQueryItem queryItem = new DAPQueryItem();
        queryItem.setObjectType(DAPQueryItem.ObjectType.ENTRY);
        queryItem.setDAPSelect(select);
        DAPQuery query = new DAPQuery("urn:liberty:id-sis-dap:2006-02:dst-2.1", LOCAL_NAME, "dap");
        query.setItemID(itemId);
        query.getDAPQueryItems().add((Object)queryItem);
        return query;
    }

    public DAPQuery(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public XMLObjectChildrenList<DAPQueryItem> getDAPQueryItems() {
        if (null == this.queryItems) {
            this.queryItems = new XMLObjectChildrenList((XMLObject)this);
        }
        return this.queryItems;
    }

    public XMLObjectChildrenList<DAPTestItem> getDAPTestItems() {
        if (null == this.testItems) {
            this.testItems = new XMLObjectChildrenList((XMLObject)this);
        }
        return this.testItems;
    }

    public XMLObjectChildrenList<DAPSubscription> getDAPSubscriptions() {
        if (null == this.subscriptions) {
            this.subscriptions = new XMLObjectChildrenList((XMLObject)this);
        }
        return this.subscriptions;
    }

    @Override
    public List<XMLObject> getOrderedChildren() {
        LinkedList<Object> children = new LinkedList<Object>();
        children.addAll(super.getOrderedChildren());
        if (null != this.testItems) {
            children.addAll((Collection<Object>)this.testItems);
        }
        if (null != this.queryItems) {
            children.addAll((Collection<Object>)this.queryItems);
        }
        if (null != this.subscriptions) {
            children.addAll((Collection<Object>)this.subscriptions);
        }
        return Collections.unmodifiableList(children);
    }

    public static class Builder
    extends AbstractXMLObjectBuilder<DAPQuery> {
        public DAPQuery buildObject(String namespaceURI, String localName, String namespacePrefix) {
            return new DAPQuery(namespaceURI, localName, namespacePrefix);
        }
    }

    public static class Unmarshaller
    extends RequestType.Unmarshaller {
        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException {
            DAPQuery obj = (DAPQuery)parentXMLObject;
            if (childXMLObject instanceof DAPTestItem) {
                obj.getDAPTestItems().add((Object)((DAPTestItem)childXMLObject));
            } else if (childXMLObject instanceof DAPQueryItem) {
                obj.getDAPQueryItems().add((Object)((DAPQueryItem)childXMLObject));
            } else if (childXMLObject instanceof DAPSubscription) {
                obj.getDAPSubscriptions().add((Object)((DAPSubscription)childXMLObject));
            } else {
                super.processChildElement(parentXMLObject, childXMLObject);
            }
        }
    }

    public static class Marshaller
    extends RequestType.Marshaller {
    }
}

