/*
 * Decompiled with CFR 0.152.
 */
package org.openliberty.xmltooling.pp.subs;

import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.namespace.QName;
import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.subs.Subscription;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class PPSubscription
extends Subscription {
    public static final String LOCAL_NAME = "Subscription";
    public static final QName DEFAULT_QNAME = new QName(Konstantz.PP_SUBS_NS, "Subscription", "ppsubs");
    private String subscriberName;
    private String subscriberURI;
    private URL notifyToURL;
    public static final String ATT_SUBSCRIBER_NAME = "subscriberName";
    public static final String ATT_SUBSCRIBER_URI = "subscriberURI";
    public static final String ATT_NOTIFY_TO_URL = "notifyToURL";

    public PPSubscription() {
        super(Konstantz.PP_SUBS_NS, LOCAL_NAME, "ppsubs");
    }

    public PPSubscription(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public String getSubscriberName() {
        return this.subscriberName;
    }

    public void setSubscriberName(String subscriberName) {
        this.subscriberName = this.prepareForAssignment(this.subscriberName, subscriberName);
    }

    public String getSubscriberURI() {
        return this.subscriberURI;
    }

    public void setSubscriberURI(String subscriberURI) {
        this.subscriberURI = this.prepareForAssignment(this.subscriberURI, subscriberURI);
    }

    public URL getNotifyToURL() {
        return this.notifyToURL;
    }

    public void setNotifyToURL(URL notifyToURL) {
        this.notifyToURL = (URL)this.prepareForAssignment(this.notifyToURL, notifyToURL);
    }

    public static class Unmarshaller
    extends Subscription.Unmarshaller {
        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException {
            PPSubscription subscription = (PPSubscription)xmlObject;
            if (attribute.getLocalName().equals(PPSubscription.ATT_SUBSCRIBER_NAME)) {
                subscription.setSubscriberName(attribute.getValue());
            } else if (attribute.getLocalName().equals(PPSubscription.ATT_SUBSCRIBER_NAME)) {
                subscription.setSubscriberURI(attribute.getValue());
            } else if (attribute.getLocalName().equals(PPSubscription.ATT_NOTIFY_TO_URL)) {
                try {
                    subscription.setNotifyToURL(new URL(attribute.getValue()));
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            } else {
                super.processAttribute(xmlObject, attribute);
            }
        }
    }

    public static class Marshaller
    extends Subscription.Marshaller {
        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException {
            PPSubscription subscription = (PPSubscription)xmlObject;
            if (subscription.getSubscriberName() != null) {
                domElement.setAttributeNS(null, PPSubscription.ATT_SUBSCRIBER_NAME, subscription.getSubscriberName());
            }
            if (subscription.getSubscriberURI() != null) {
                domElement.setAttributeNS(null, PPSubscription.ATT_SUBSCRIBER_URI, subscription.getSubscriberURI());
            }
            if (subscription.getNotifyToURL() != null) {
                domElement.setAttributeNS(null, PPSubscription.ATT_NOTIFY_TO_URL, subscription.getNotifyToURL().toString());
            }
            super.marshallAttributes(xmlObject, domElement);
        }
    }

    public static class Builder
    extends AbstractXMLObjectBuilder<PPSubscription> {
        public PPSubscription buildObject(String namespaceURI, String localName, String namespacePrefix) {
            return new PPSubscription(namespaceURI, localName, namespacePrefix);
        }
    }
}

