/*
 * Decompiled with CFR 0.152.
 */
package org.openliberty.xmltooling.ps;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.joda.time.DateTime;
import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.openliberty.xmltooling.ps.DisplayName;
import org.openliberty.xmltooling.ps.ObjectID;
import org.openliberty.xmltooling.ps.ObjectRef;
import org.openliberty.xmltooling.ps.Tag;
import org.openliberty.xmltooling.ps.TargetObjectID;
import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.ElementExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.IndexedXMLObjectChildrenList;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class PSObject
extends AbstractXMLObject
implements ElementExtensibleXMLObject {
    public static String LOCAL_NAME = "Object";
    public static String ATT_NODE_TYPE = "NodeType";
    public static String ATT_CREATED_DATE_TIME = "CreatedDateTime";
    public static String ATT_MODIFIED_DATE_TIME = "ModifiedDateTime";
    private NodeType nodeType;
    private DateTime createdDateTime;
    private DateTime modifiedDateTime;
    private ObjectID objectID;
    private XMLObjectChildrenList<DisplayName> displayNames;
    private XMLObjectChildrenList<Tag> tags;
    private XMLObjectChildrenList<PSObject> objects;
    private XMLObjectChildrenList<ObjectRef> objectRefs;
    private IndexedXMLObjectChildrenList<XMLObject> unknownXMLObjects = new IndexedXMLObjectChildrenList((XMLObject)this);

    public PSObject() {
        super("urn:liberty:ps:2006-08", LOCAL_NAME, "ps");
        this.displayNames = new XMLObjectChildrenList((XMLObject)this);
    }

    public PSObject(String displayName) {
        super("urn:liberty:ps:2006-08", LOCAL_NAME, "ps");
        this.displayNames = new XMLObjectChildrenList((XMLObject)this);
        if (null != displayName) {
            DisplayName _d = new DisplayName(displayName, DisplayName.DEFAULT_LOCALE);
            this.displayNames.add((Object)_d);
        }
    }

    protected PSObject(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
        this.displayNames = new XMLObjectChildrenList((XMLObject)this);
    }

    public static PSObject createEntity(String displayName) {
        PSObject object = new PSObject(displayName);
        object.setNodeType(NodeType.ENTITY);
        return object;
    }

    public static PSObject createCollection(String displayName) {
        PSObject object = new PSObject(displayName);
        object.setNodeType(NodeType.COLLECTION);
        return object;
    }

    public boolean isCollection() {
        return this.nodeType == NodeType.COLLECTION;
    }

    public boolean isEntity() {
        return this.nodeType == NodeType.ENTITY;
    }

    public void print() {
        PSObject.printPSObject(this);
    }

    public static void printPSObject(PSObject object) {
        PSObject.printPSObject(object, 0);
    }

    private static void printPSObject(PSObject object, int depth) {
        for (int i = 0; i < depth; ++i) {
            System.err.print("\t");
        }
        System.err.print(object.getNodeType().urn() + ": " + object.getName() + " / " + object.getObjectID().getValue());
        XMLObjectChildrenList<Tag> tags = object.getTags();
        if (null != tags && tags.size() > 0) {
            System.err.print(" { ");
            for (Tag tag : tags) {
                System.err.print(tag.getValue() + " ");
            }
            System.err.print("}");
        }
        System.err.print("\n");
        if (object.getNodeType() == NodeType.COLLECTION) {
            XMLObjectChildrenList<PSObject> children = object.getObjects();
            for (PSObject child : children) {
                PSObject.printPSObject(child, depth + 1);
            }
        }
    }

    public ObjectRef createObjectRef() {
        ObjectRef objectRef = null;
        ObjectID objectId = this.getObjectID();
        if (objectId != null && objectId.getValue() != null) {
            objectRef = new ObjectRef();
            objectRef.setValue(objectId.getValue());
        }
        return objectRef;
    }

    public TargetObjectID createTargetObjectID() {
        TargetObjectID targetObjectID = null;
        ObjectID objectId = this.getObjectID();
        if (objectId != null && objectId.getValue() != null) {
            targetObjectID = new TargetObjectID();
            targetObjectID.setValue(objectId.getValue());
        }
        return targetObjectID;
    }

    public String getName() {
        if (null != this.displayNames && this.displayNames.size() > 0) {
            for (DisplayName dname : this.displayNames) {
                if (!dname.isDefault()) continue;
                return dname.getValue();
            }
            String name = ((DisplayName)this.displayNames.get(0)).getValue();
            if (name != null) {
                return name;
            }
        }
        return "";
    }

    public void setName(String displayNameValue) {
        if (null != this.displayNames && this.displayNames.size() > 0) {
            ((DisplayName)this.displayNames.get(0)).setValue(displayNameValue);
        } else {
            DisplayName displayName = new DisplayName(displayNameValue, null);
            this.getDisplayNames().add((Object)displayName);
        }
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(NodeType nodeType) {
        this.nodeType = nodeType;
    }

    public void setCreatedDateTime(DateTime createdDateTime) {
        this.createdDateTime = (DateTime)this.prepareForAssignment(this.createdDateTime, createdDateTime);
    }

    public DateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    public void setModifiedDateTime(DateTime modifiedDateTime) {
        this.modifiedDateTime = (DateTime)this.prepareForAssignment(this.modifiedDateTime, modifiedDateTime);
    }

    public DateTime getModifiedDateTime() {
        return this.modifiedDateTime;
    }

    public void setObjectID(ObjectID objectID) {
        this.objectID = (ObjectID)this.prepareForAssignment((XMLObject)this.objectID, (XMLObject)objectID);
    }

    public ObjectID getObjectID() {
        return this.objectID;
    }

    public XMLObjectChildrenList<DisplayName> getDisplayNames() {
        return this.displayNames;
    }

    public XMLObjectChildrenList<Tag> getTags() {
        if (null == this.tags) {
            this.tags = new XMLObjectChildrenList((XMLObject)this);
        }
        return this.tags;
    }

    public XMLObjectChildrenList<PSObject> getObjects() {
        if (null == this.objects) {
            this.objects = new XMLObjectChildrenList((XMLObject)this);
        }
        return this.objects;
    }

    public XMLObjectChildrenList<ObjectRef> getObjectRefs() {
        if (null == this.objectRefs) {
            this.objectRefs = new XMLObjectChildrenList((XMLObject)this);
        }
        return this.objectRefs;
    }

    public List<XMLObject> getUnknownXMLObjects() {
        return this.unknownXMLObjects;
    }

    public List<XMLObject> getUnknownXMLObjects(QName typeOrName) {
        return this.unknownXMLObjects.subList(typeOrName);
    }

    public List<XMLObject> getOrderedChildren() {
        LinkedList<Object> children = new LinkedList<Object>();
        children.add((Object)this.objectID);
        children.addAll((Collection<Object>)this.displayNames);
        if (null != this.tags) {
            children.addAll((Collection<Object>)this.tags);
        }
        if (null != this.objects) {
            children.addAll((Collection<Object>)this.objects);
        }
        if (null != this.objectRefs) {
            children.addAll((Collection<Object>)this.objectRefs);
        }
        children.addAll((Collection<Object>)this.unknownXMLObjects);
        return Collections.unmodifiableList(children);
    }

    public static class Unmarshaller
    extends AbstractXMLObjectUnmarshaller {
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException {
            PSObject o = (PSObject)xmlObject;
            String localName = attribute.getLocalName();
            if (localName.equals(ATT_NODE_TYPE)) {
                o.setNodeType(NodeType.forUrn(attribute.getValue()));
            } else if (localName.equals(ATT_CREATED_DATE_TIME)) {
                o.setCreatedDateTime(OpenLibertyHelpers.dateTimeForString(attribute.getValue()));
            } else if (localName.equals(ATT_MODIFIED_DATE_TIME)) {
                o.setModifiedDateTime(OpenLibertyHelpers.dateTimeForString(attribute.getValue()));
            }
        }

        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException {
            PSObject o = (PSObject)parentXMLObject;
            if (childXMLObject instanceof ObjectID) {
                o.setObjectID((ObjectID)childXMLObject);
            } else if (childXMLObject instanceof Tag) {
                o.getTags().add((Object)((Tag)childXMLObject));
            } else if (childXMLObject instanceof DisplayName) {
                o.getDisplayNames().add((Object)((DisplayName)childXMLObject));
            } else if (childXMLObject instanceof PSObject) {
                o.getObjects().add((Object)((PSObject)childXMLObject));
            } else if (childXMLObject instanceof ObjectRef) {
                o.getObjectRefs().add((Object)((ObjectRef)childXMLObject));
            } else {
                o.getUnknownXMLObjects().add(childXMLObject);
            }
        }

        protected void processElementContent(XMLObject xmlObject, String elementContent) {
        }
    }

    public static class Marshaller
    extends AbstractXMLObjectMarshaller {
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException {
            PSObject o = (PSObject)xmlObject;
            if (o.getNodeType() != null) {
                domElement.setAttributeNS(null, ATT_NODE_TYPE, o.getNodeType().urn);
            }
            if (o.getCreatedDateTime() != null) {
                domElement.setAttributeNS(null, ATT_CREATED_DATE_TIME, OpenLibertyHelpers.stringForDateTime(o.getCreatedDateTime()));
            }
            if (o.getModifiedDateTime() != null) {
                domElement.setAttributeNS(null, ATT_MODIFIED_DATE_TIME, OpenLibertyHelpers.stringForDateTime(o.getModifiedDateTime()));
            }
        }

        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException {
        }
    }

    public static class Builder
    extends AbstractXMLObjectBuilder<PSObject> {
        public PSObject buildObject(String namespaceURI, String localName, String namespacePrefix) {
            return new PSObject(namespaceURI, localName, namespacePrefix);
        }
    }

    public static enum NodeType {
        COLLECTION("urn:liberty:ps:collection"),
        ENTITY("urn:liberty:ps:entity");

        String urn;

        private NodeType(String urn) {
            this.urn = urn;
        }

        public String urn() {
            return this.urn;
        }

        static NodeType forUrn(String urn) {
            if (null != urn && urn.equals(NodeType.COLLECTION.urn)) {
                return COLLECTION;
            }
            return ENTITY;
        }
    }
}

