/*
 * Decompiled with CFR 0.152.
 */
package org.openliberty.xmltooling.subs;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.joda.time.DateTime;
import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.openliberty.xmltooling.subs.RefItem;
import org.openliberty.xmltooling.utility_2_0.Extension;
import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class Subscription
extends AbstractXMLObject {
    public static String LOCAL_NAME = "Subscription";
    private String subscriptionID;
    private String notifyToRef;
    private String adminNotifyToRef;
    private DateTime starts;
    private DateTime expires;
    private String id;
    private IncludeDataEnum includeData;
    public static final String ATT_SUBSCRIPTION_ID = "subscriptionID";
    public static final String ATT_NOTIFY_TO_REF = "notifyToRef";
    public static final String ATT_ADMIN_NOTIFY_TO_REF = "adminNotifyToRef";
    public static final String ATT_STARTS = "starts";
    public static final String ATT_EXPIRES = "expires";
    public static final String ATT_ID = "id";
    public static final String ATT_INCLUDE_DATA = "includeData";
    private XMLObjectChildrenList<Extension> extensions;
    private XMLObjectChildrenList<RefItem> refItems;

    public Subscription() {
        super("urn:liberty:ssos:2006-08", LOCAL_NAME, "subs");
    }

    protected Subscription(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public String getNotifyToRef() {
        return this.notifyToRef;
    }

    public void setNotifyToRef(String notifyToRef) {
        this.notifyToRef = this.prepareForAssignment(this.notifyToRef, notifyToRef);
    }

    public String getAdminNotifyToRef() {
        return this.adminNotifyToRef;
    }

    public void setAdminNotifyToRef(String adminNotifyToRef) {
        this.adminNotifyToRef = this.prepareForAssignment(this.adminNotifyToRef, adminNotifyToRef);
    }

    public DateTime getStarts() {
        return this.starts;
    }

    public void setStarts(DateTime starts) {
        this.starts = (DateTime)this.prepareForAssignment(this.starts, starts);
    }

    public DateTime getExpires() {
        return this.expires;
    }

    public void setExpires(DateTime expires) {
        this.expires = (DateTime)this.prepareForAssignment(this.expires, expires);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = this.prepareForAssignment(this.id, id);
    }

    public IncludeDataEnum getIncludeData() {
        return this.includeData;
    }

    public void setIncludeData(IncludeDataEnum includeData) {
        this.includeData = (IncludeDataEnum)((Object)this.prepareForAssignment((Object)this.includeData, (Object)includeData));
    }

    public void setSubscriptionID(String subscriptionID) {
        this.subscriptionID = this.prepareForAssignment(this.subscriptionID, subscriptionID);
    }

    public String getSubscriptionID() {
        return this.subscriptionID;
    }

    public XMLObjectChildrenList<RefItem> getRefItems() {
        if (null == this.refItems) {
            this.refItems = new XMLObjectChildrenList((XMLObject)this);
        }
        return this.refItems;
    }

    public XMLObjectChildrenList<Extension> getExtensions() {
        if (null == this.extensions) {
            this.extensions = new XMLObjectChildrenList((XMLObject)this);
        }
        return this.extensions;
    }

    public List<XMLObject> getOrderedChildren() {
        LinkedList<AbstractSignableXMLObject> children = new LinkedList<AbstractSignableXMLObject>();
        if (null != this.extensions) {
            children.addAll((Collection<AbstractSignableXMLObject>)this.extensions);
        }
        if (null != this.refItems) {
            children.addAll((Collection<AbstractSignableXMLObject>)this.refItems);
        }
        return Collections.unmodifiableList(children);
    }

    public static class Unmarshaller
    extends AbstractXMLObjectUnmarshaller {
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException {
            Subscription object = (Subscription)xmlObject;
            if (attribute.getLocalName().equals(Subscription.ATT_SUBSCRIPTION_ID)) {
                object.setSubscriptionID(attribute.getValue());
            } else if (attribute.getLocalName().equals(Subscription.ATT_NOTIFY_TO_REF)) {
                object.setNotifyToRef(attribute.getValue());
            } else if (attribute.getLocalName().equals(Subscription.ATT_ADMIN_NOTIFY_TO_REF)) {
                object.setAdminNotifyToRef(attribute.getValue());
            } else if (attribute.getLocalName().equals(Subscription.ATT_STARTS)) {
                object.setStarts(OpenLibertyHelpers.dateTimeForString(attribute.getValue()));
            } else if (attribute.getLocalName().equals(Subscription.ATT_EXPIRES)) {
                object.setExpires(OpenLibertyHelpers.dateTimeForString(attribute.getValue()));
            } else if (attribute.getLocalName().equals(Subscription.ATT_ID)) {
                object.setId(attribute.getValue());
            } else if (attribute.getLocalName().equals(Subscription.ATT_INCLUDE_DATA)) {
                object.setIncludeData(IncludeDataEnum.getIncludeDataEnumForValue(attribute.getValue()));
            }
        }

        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException {
            Subscription object = (Subscription)parentXMLObject;
            if (childXMLObject instanceof Extension) {
                object.getExtensions().add((Object)((Extension)childXMLObject));
            } else if (childXMLObject instanceof RefItem) {
                object.getRefItems().add((Object)((RefItem)childXMLObject));
            }
        }

        protected void processElementContent(XMLObject xmlObject, String elementContent) {
        }
    }

    public static class Marshaller
    extends AbstractXMLObjectMarshaller {
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException {
            Subscription object = (Subscription)xmlObject;
            if (object.getSubscriptionID() != null) {
                domElement.setAttributeNS(null, Subscription.ATT_SUBSCRIPTION_ID, object.getSubscriptionID());
            }
            if (object.getNotifyToRef() != null) {
                domElement.setAttributeNS(null, Subscription.ATT_NOTIFY_TO_REF, object.getNotifyToRef());
            }
            if (object.getAdminNotifyToRef() != null) {
                domElement.setAttributeNS(null, Subscription.ATT_ADMIN_NOTIFY_TO_REF, object.getAdminNotifyToRef());
            }
            if (object.getStarts() != null) {
                domElement.setAttributeNS(null, Subscription.ATT_STARTS, OpenLibertyHelpers.stringForDateTime(object.getStarts()));
            }
            if (object.getExpires() != null) {
                domElement.setAttributeNS(null, Subscription.ATT_EXPIRES, OpenLibertyHelpers.stringForDateTime(object.getExpires()));
            }
            if (object.getId() != null) {
                domElement.setAttributeNS(null, Subscription.ATT_ID, object.getId());
            }
            if (object.getIncludeData() != null) {
                domElement.setAttributeNS(null, Subscription.ATT_INCLUDE_DATA, object.getIncludeData().getValue());
            }
        }

        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException {
        }
    }

    public static class Builder
    extends AbstractXMLObjectBuilder<Subscription> {
        public Subscription buildObject(String namespaceURI, String localName, String namespacePrefix) {
            return new Subscription(namespaceURI, localName, namespacePrefix);
        }
    }

    public static enum IncludeDataEnum {
        YES("Yes"),
        NO("No"),
        YES_WITH_COMMON_ATTRIBUTES("YesWithCommonAttributes");

        private String value;

        private IncludeDataEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static IncludeDataEnum getIncludeDataEnumForValue(String value) {
            if (value != null) {
                if (value.equals(IncludeDataEnum.YES.value)) {
                    return YES;
                }
                if (value.equals(IncludeDataEnum.NO.value)) {
                    return NO;
                }
                if (value.equals(IncludeDataEnum.YES_WITH_COMMON_ATTRIBUTES.value)) {
                    return YES_WITH_COMMON_ATTRIBUTES;
                }
            }
            return null;
        }
    }
}

