/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.stream.JsonGenerator;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonNegative;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.storage.StorageSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractSPSessionSerializer
extends AbstractInitializableComponent
implements StorageSerializer<SPSession> {
    @Nonnull
    @NotEmpty
    private static final String SERVICE_ID_FIELD = "id";
    @Nonnull
    @NotEmpty
    private static final String CREATION_INSTANT_FIELD = "ts";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractSPSessionSerializer.class);
    @Duration
    @NonNegative
    private final long expirationOffset;

    protected AbstractSPSessionSerializer(@Duration @NonNegative long offset) {
        this.expirationOffset = Constraint.isGreaterThanOrEqual((long)0L, (long)offset, (String)"Offset must be greater than or equal to zero");
    }

    @Nonnull
    @NotEmpty
    public String serialize(@Nonnull SPSession instance) throws IOException {
        try {
            StringWriter sink = new StringWriter(128);
            JsonGenerator gen = Json.createGenerator((Writer)sink);
            gen.writeStartObject().write(SERVICE_ID_FIELD, instance.getId()).write(CREATION_INSTANT_FIELD, instance.getCreationInstant());
            this.doSerializeAdditional(instance, gen);
            gen.writeEnd().close();
            return sink.toString();
        }
        catch (JsonException e) {
            this.log.error("Exception while serializing SPSession", (Throwable)e);
            throw new IOException("Exception while serializing SPSession", e);
        }
    }

    @Nonnull
    public SPSession deserialize(long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable Long expiration) throws IOException {
        if (expiration == null) {
            throw new IOException("SPSession objects must have an expiration");
        }
        try {
            JsonReader reader = Json.createReader((Reader)new StringReader(value));
            JsonStructure st = reader.read();
            if (!(st instanceof JsonObject)) {
                throw new IOException("Found invalid data structure while parsing SPSession");
            }
            JsonObject obj = (JsonObject)st;
            String serviceId = obj.getString(SERVICE_ID_FIELD);
            long creation = obj.getJsonNumber(CREATION_INSTANT_FIELD).longValueExact();
            return this.doDeserialize(obj, serviceId, creation, expiration - this.expirationOffset);
        }
        catch (ArithmeticException | ClassCastException | NullPointerException | JsonException e) {
            this.log.error("Exception while parsing SPSession", e);
            throw new IOException("Found invalid data structure while parsing SPSession", e);
        }
    }

    protected void doSerializeAdditional(@Nonnull SPSession instance, @Nonnull JsonGenerator generator) {
    }

    @Nonnull
    protected abstract SPSession doDeserialize(@Nonnull JsonObject var1, @Nonnull @NotEmpty String var2, @Duration @Positive long var3, @Duration @Positive long var5) throws IOException;
}

