/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.mapping;

import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributeEncoder;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.AttributeDefinition;
import net.shibboleth.idp.attribute.resolver.AttributeResolver;
import net.shibboleth.idp.saml.attribute.encoding.AttributeDesignatorMapperProcessor;
import net.shibboleth.idp.saml.attribute.mapping.AbstractSAMLAttributeDesignatorMapper;
import net.shibboleth.idp.saml.attribute.mapping.AttributeMapper;
import net.shibboleth.idp.saml.attribute.mapping.AttributesMapper;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.saml.saml1.core.AttributeDesignator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSAMLAttributeDesignatorsMapper<OutType extends IdPAttribute>
extends AbstractIdentifiableInitializableComponent
implements AttributesMapper<AttributeDesignator, OutType> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractSAMLAttributeDesignatorsMapper.class);
    @Nonnull
    @NonnullElements
    private Collection<AttributeMapper<AttributeDesignator, OutType>> mappers;
    @Nullable
    private String logPrefix;

    public AbstractSAMLAttributeDesignatorsMapper() {
        this.mappers = Collections.emptyList();
    }

    public AbstractSAMLAttributeDesignatorsMapper(@Nonnull AttributeResolver resolver, @Nonnull @NotEmpty String id, @Nonnull Supplier<AbstractSAMLAttributeDesignatorMapper<OutType>> mapperFactory) {
        this.setId(id);
        this.mappers = Collections.emptyList();
        HashMultimap theMappers = HashMultimap.create();
        for (AttributeDefinition attributeDefinition : resolver.getAttributeDefinitions().values()) {
            for (AttributeEncoder encoder : attributeDefinition.getAttributeEncoders()) {
                if (!(encoder instanceof AttributeDesignatorMapperProcessor)) continue;
                AttributeDesignatorMapperProcessor factory = (AttributeDesignatorMapperProcessor)encoder;
                AbstractSAMLAttributeDesignatorMapper mapper = (AbstractSAMLAttributeDesignatorMapper)mapperFactory.get();
                factory.populateAttributeMapper(mapper);
                theMappers.put((Object)mapper, (Object)attributeDefinition.getId());
            }
        }
        this.mappers = new ArrayList<AttributeMapper<AttributeDesignator, OutType>>(theMappers.values().size());
        for (Map.Entry entry : theMappers.asMap().entrySet()) {
            AbstractSAMLAttributeDesignatorMapper mapper = (AbstractSAMLAttributeDesignatorMapper)entry.getKey();
            mapper.setAttributeIds(new ArrayList<String>((Collection)entry.getValue()));
            this.mappers.add(mapper);
        }
    }

    @Nonnull
    @NonnullElements
    public Collection<AttributeMapper<AttributeDesignator, OutType>> getMappers() {
        return this.mappers;
    }

    public void setMappers(@Nonnull Collection<AttributeMapper<AttributeDesignator, OutType>> theMappers) {
        this.mappers = (Collection)Constraint.isNotNull(theMappers, (String)"Mappers list cannot be null");
    }

    @Override
    @Nonnull
    @NonnullElements
    public Multimap<String, OutType> mapAttributes(@Nonnull @NonnullElements List<AttributeDesignator> prototypes) {
        ArrayListMultimap result = ArrayListMultimap.create();
        for (AttributeDesignator prototype : prototypes) {
            for (AttributeMapper<AttributeDesignator, OutType> mapper : this.mappers) {
                Map<String, OutType> mappedAttributes = mapper.mapAttribute(prototype);
                this.log.debug("{} SAML attribute '{}' mapped to {} attributes by mapper '{}'", new Object[]{this.getLogPrefix(), prototype.getAttributeName(), mappedAttributes.size(), mapper.getId()});
                for (Map.Entry<String, OutType> entry : mappedAttributes.entrySet()) {
                    result.put((Object)entry.getKey(), entry.getValue());
                }
            }
        }
        return result;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.logPrefix = null;
        for (AttributeMapper<AttributeDesignator, OutType> mapper : this.mappers) {
            ComponentSupport.initialize(mapper);
        }
    }

    @Nonnull
    @NotEmpty
    private String getLogPrefix() {
        String s = this.logPrefix;
        if (null == s) {
            this.logPrefix = s = "Attribute Mappers : '" + this.getId() + "':";
        }
        return s;
    }
}

