/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.idwsf.profile.config;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import javax.annotation.Nonnull;
import net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

public class SSOSProfileConfiguration
extends BrowserSSOProfileConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROFILE_ID = "http://shibboleth.net/ns/profiles/liberty/ssos";
    @Nonnull
    private Predicate<ProfileRequestContext> delegationPredicate = Predicates.alwaysFalse();

    public SSOSProfileConfiguration() {
        this(PROFILE_ID);
    }

    protected SSOSProfileConfiguration(String profileId) {
        super(profileId);
    }

    @Nonnull
    public Predicate<ProfileRequestContext> getDelegationPredicate() {
        return this.delegationPredicate;
    }

    public void setDelegationPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.delegationPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Delegation predicate cannot be null");
    }
}

