/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml1.profile.config;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.config.AuthenticationProfileConfiguration;
import net.shibboleth.idp.saml.authn.principal.AuthenticationMethodPrincipal;
import net.shibboleth.idp.saml.profile.config.AbstractSAMLProfileConfiguration;
import net.shibboleth.idp.saml.profile.config.SAMLArtifactAwareProfileConfiguration;
import net.shibboleth.idp.saml.profile.config.SAMLArtifactConfiguration;
import net.shibboleth.idp.saml.saml1.profile.config.SAML1ProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class BrowserSSOProfileConfiguration
extends AbstractSAMLProfileConfiguration
implements SAML1ProfileConfiguration,
SAMLArtifactAwareProfileConfiguration,
AuthenticationProfileConfiguration {
    public static final String PROFILE_ID = "http://shibboleth.net/ns/profiles/saml1/sso/browser";
    @Nullable
    private SAMLArtifactConfiguration artifactConfig;
    private boolean resolveAttributes;
    private boolean includeAttributeStatement;
    @Nonnull
    @NonnullElements
    private List<AuthenticationMethodPrincipal> defaultAuthenticationMethods;
    @Nonnull
    @NonnullElements
    private Set<String> authenticationFlows;
    @Nonnull
    @NonnullElements
    private List<String> postAuthenticationFlows;
    @Nonnull
    @NonnullElements
    private List<String> nameIDFormatPrecedence;

    public BrowserSSOProfileConfiguration() {
        this(PROFILE_ID);
    }

    protected BrowserSSOProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
        this.setSignResponses((Predicate<ProfileRequestContext>)Predicates.alwaysTrue());
        this.resolveAttributes = true;
        this.includeAttributeStatement = false;
        this.defaultAuthenticationMethods = Collections.emptyList();
        this.authenticationFlows = Collections.emptySet();
        this.postAuthenticationFlows = Collections.emptyList();
        this.nameIDFormatPrecedence = Collections.emptyList();
    }

    @Override
    @Nullable
    public SAMLArtifactConfiguration getArtifactConfiguration() {
        return this.artifactConfig;
    }

    public void setArtifactConfiguration(@Nullable SAMLArtifactConfiguration config) {
        this.artifactConfig = config;
    }

    public boolean resolveAttributes() {
        return this.resolveAttributes;
    }

    public void setResolveAttributes(boolean flag) {
        this.resolveAttributes = flag;
    }

    public boolean includeAttributeStatement() {
        return this.includeAttributeStatement;
    }

    public void setIncludeAttributeStatement(boolean include) {
        this.includeAttributeStatement = include;
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<Principal> getDefaultAuthenticationMethods() {
        return ImmutableList.copyOf(this.defaultAuthenticationMethods);
    }

    public void setDefaultAuthenticationMethods(@Nonnull @NonnullElements List<AuthenticationMethodPrincipal> methods) {
        Constraint.isNotNull(methods, (String)"List of methods cannot be null");
        this.defaultAuthenticationMethods = new ArrayList<AuthenticationMethodPrincipal>(Collections2.filter(methods, (Predicate)Predicates.notNull()));
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Set<String> getAuthenticationFlows() {
        return ImmutableSet.copyOf(this.authenticationFlows);
    }

    public void setAuthenticationFlows(@Nonnull @NonnullElements Collection<String> flows) {
        Constraint.isNotNull(flows, (String)"Collection of flows cannot be null");
        this.authenticationFlows = new HashSet<String>(StringSupport.normalizeStringCollection(flows));
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<String> getPostAuthenticationFlows() {
        return this.postAuthenticationFlows;
    }

    public void setPostAuthenticationFlows(@Nonnull @NonnullElements Collection<String> flows) {
        Constraint.isNotNull(flows, (String)"Collection of flows cannot be null");
        this.postAuthenticationFlows = new ArrayList<String>(StringSupport.normalizeStringCollection(flows));
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<String> getNameIDFormatPrecedence() {
        return ImmutableList.copyOf(this.nameIDFormatPrecedence);
    }

    public void setNameIDFormatPrecedence(@Nonnull @NonnullElements List<String> formats) {
        Constraint.isNotNull(formats, (String)"List of formats cannot be null");
        this.nameIDFormatPrecedence = new ArrayList<String>(StringSupport.normalizeStringCollection(formats));
    }
}

