/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.IdentifiedComponent;

@ThreadSafe
public interface Matcher
extends IdentifiedComponent {
    public static final Matcher MATCHES_ALL = new Matcher(){

        @Override
        public Set<IdPAttributeValue<?>> getMatchingValues(@Nonnull IdPAttribute attribute, @Nonnull AttributeFilterContext filterContext) {
            return ImmutableSet.copyOf((Collection)attribute.getValues());
        }

        @Nullable
        public String getId() {
            return "MATCHES_ALL";
        }
    };
    public static final Matcher MATCHES_NONE = new Matcher(){

        @Override
        public Set<IdPAttributeValue<?>> getMatchingValues(@Nonnull IdPAttribute attribute, @Nonnull AttributeFilterContext filterContext) {
            return Collections.emptySet();
        }

        @Nullable
        public String getId() {
            return "MATCHES_NONE";
        }
    };
    public static final Matcher MATCHER_FAILS = new Matcher(){

        @Override
        public Set<IdPAttributeValue<?>> getMatchingValues(@Nonnull IdPAttribute attribute, @Nonnull AttributeFilterContext filterContext) {
            return null;
        }

        @Nullable
        public String getId() {
            return "MATCHER_FAILS";
        }
    };

    @Nullable
    @NonnullElements
    @Unmodifiable
    public Set<IdPAttributeValue<?>> getMatchingValues(@Nonnull IdPAttribute var1, @Nonnull AttributeFilterContext var2);
}

