/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.context;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.MapConstraint;
import com.google.common.collect.MapConstraints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.collection.CollectionSupport;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;

@NotThreadSafe
public final class AttributeFilterContext
extends BaseContext {
    private Map<String, IdPAttribute> prefilteredAttributes = MapConstraints.constrainedMap(new HashMap(), (MapConstraint)MapConstraints.notNull());
    private Map<String, IdPAttribute> filteredAttributes = MapConstraints.constrainedMap(new HashMap(), (MapConstraint)MapConstraints.notNull());
    private String principal;
    @Nullable
    private String attributeIssuerID;
    @Nullable
    private String attributeRecipientID;
    @Nullable
    private String principalAuthenticationMethod;
    @Nullable
    private SAMLMetadataContext requesterMetadataContext;
    @NonnullAfterInit
    private Function<AttributeFilterContext, SAMLMetadataContext> requesterMetadataContextLookupStrategy;

    @Nonnull
    @NonnullElements
    public Map<String, IdPAttribute> getPrefilteredIdPAttributes() {
        return this.prefilteredAttributes;
    }

    public void setPrefilteredIdPAttributes(@Nullable @NullableElements Collection<IdPAttribute> attributes) {
        ArrayList checkedAttributes = new ArrayList();
        CollectionSupport.addIf(checkedAttributes, attributes, (Predicate)Predicates.notNull());
        this.prefilteredAttributes = MapConstraints.constrainedMap(new HashMap(checkedAttributes.size()), (MapConstraint)MapConstraints.notNull());
        for (IdPAttribute attribute : checkedAttributes) {
            this.prefilteredAttributes.put(attribute.getId(), attribute);
        }
    }

    @Nonnull
    @NonnullElements
    public Map<String, IdPAttribute> getFilteredIdPAttributes() {
        return this.filteredAttributes;
    }

    public void setFilteredIdPAttributes(@Nullable @NullableElements Collection<IdPAttribute> attributes) {
        ArrayList checkedAttributes = new ArrayList();
        CollectionSupport.addIf(checkedAttributes, attributes, (Predicate)Predicates.notNull());
        this.filteredAttributes = MapConstraints.constrainedMap(new HashMap(checkedAttributes.size()), (MapConstraint)MapConstraints.notNull());
        for (IdPAttribute attribute : checkedAttributes) {
            this.filteredAttributes.put(attribute.getId(), attribute);
        }
    }

    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String who) {
        this.principal = who;
    }

    @Nullable
    public String getAttributeIssuerID() {
        return this.attributeIssuerID;
    }

    @Nullable
    public void setAttributeIssuerID(@Nullable String value) {
        this.attributeIssuerID = value;
    }

    @Nullable
    public String getAttributeRecipientID() {
        return this.attributeRecipientID;
    }

    @Nullable
    public void setAttributeRecipientID(@Nullable String value) {
        this.attributeRecipientID = value;
    }

    @Nullable
    public String getPrincipalAuthenticationMethod() {
        return this.principalAuthenticationMethod;
    }

    public void setPrincipalAuthenticationMethod(@Nullable String method) {
        this.principalAuthenticationMethod = method;
    }

    @NonnullAfterInit
    public Function<AttributeFilterContext, SAMLMetadataContext> getRequesterMetadataContextLookupStrategy() {
        return this.requesterMetadataContextLookupStrategy;
    }

    public void setRequesterMetadataContextLookupStrategy(@Nonnull Function<AttributeFilterContext, SAMLMetadataContext> strategy) {
        this.requesterMetadataContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"MetadataContext lookup strategy cannot be null");
    }

    @Nullable
    public SAMLMetadataContext getRequesterMetadataContext() {
        if (null == this.requesterMetadataContext && null != this.requesterMetadataContextLookupStrategy) {
            this.requesterMetadataContext = (SAMLMetadataContext)this.requesterMetadataContextLookupStrategy.apply((Object)this);
        }
        return this.requesterMetadataContext;
    }
}

