/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.ext.spring.service.AbstractServiceableComponent;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.filter.AttributeFilter;
import net.shibboleth.idp.attribute.filter.AttributeFilterException;
import net.shibboleth.idp.attribute.filter.AttributeFilterPolicy;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterWorkContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.collection.CollectionSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class AttributeFilterImpl
extends AbstractServiceableComponent<AttributeFilter>
implements AttributeFilter {
    private final Logger log = LoggerFactory.getLogger(AttributeFilterImpl.class);
    private final List<AttributeFilterPolicy> filterPolicies;
    private String logPrefix;

    public AttributeFilterImpl(@Nonnull @NotEmpty String engineId, @Nullable @NullableElements Collection<AttributeFilterPolicy> policies) {
        this.setId(engineId);
        ArrayList checkedPolicies = new ArrayList();
        CollectionSupport.addIf(checkedPolicies, policies, (Predicate)Predicates.notNull());
        this.filterPolicies = ImmutableList.copyOf((Iterable)Iterables.filter(checkedPolicies, (Predicate)Predicates.notNull()));
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public List<AttributeFilterPolicy> getFilterPolicies() {
        return this.filterPolicies;
    }

    public void filterAttributes(@Nonnull AttributeFilterContext filterContext) throws AttributeFilterException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        Constraint.isNotNull((Object)filterContext, (String)"Attribute filter context can not be null");
        Map prefilteredAttributes = filterContext.getPrefilteredIdPAttributes();
        filterContext.getSubcontext(AttributeFilterWorkContext.class, true);
        this.log.debug("{} Beginning process of filtering the following {} attributes: {}", new Object[]{this.getLogPrefix(), prefilteredAttributes.size(), prefilteredAttributes.keySet()});
        List<AttributeFilterPolicy> policies = this.getFilterPolicies();
        for (AttributeFilterPolicy policy : policies) {
            policy.apply(filterContext);
        }
        for (String attributeId : filterContext.getPrefilteredIdPAttributes().keySet()) {
            IdPAttribute filteredAttribute;
            Collection filteredAttributeValues = this.getFilteredValues(attributeId, filterContext);
            if (null == filteredAttributeValues || filteredAttributeValues.isEmpty()) continue;
            try {
                filteredAttribute = ((IdPAttribute)prefilteredAttributes.get(attributeId)).clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AttributeFilterException((Exception)e);
            }
            filteredAttribute.setValues(filteredAttributeValues);
            filterContext.getFilteredIdPAttributes().put(filteredAttribute.getId(), filteredAttribute);
        }
    }

    @Nullable
    protected Collection getFilteredValues(@Nonnull @NotEmpty String attributeId, @Nonnull AttributeFilterContext filterContext) {
        Constraint.isNotNull((Object)attributeId, (String)"attributeId can not be null");
        Constraint.isNotNull((Object)filterContext, (String)"filterContext can not be null");
        AttributeFilterWorkContext filterWorkContext = (AttributeFilterWorkContext)filterContext.getSubcontext(AttributeFilterWorkContext.class, false);
        Constraint.isNotNull((Object)filterWorkContext, (String)"Attribute filter work context can not be null");
        Collection filteredAttributeValues = (Collection)filterWorkContext.getPermittedIdPAttributeValues().get(attributeId);
        if (filteredAttributeValues == null || filteredAttributeValues.isEmpty()) {
            this.log.debug("Attribute filtering engine '{}': no policy permitted release of attribute {} values", (Object)this.getId(), (Object)attributeId);
            return null;
        }
        if (filterWorkContext.getDeniedAttributeValues().containsKey(attributeId)) {
            filteredAttributeValues.removeAll((Collection)filterWorkContext.getDeniedAttributeValues().get(attributeId));
        }
        if (filteredAttributeValues.isEmpty()) {
            this.log.debug("Attribute filtering engine '{}': deny policies filtered out all values for attribute '{}'", (Object)this.getId(), (Object)attributeId);
        } else {
            this.log.debug("Attribute filtering engine '{}': {} values for attribute '{}' remained after filtering", new Object[]{this.getId(), filteredAttributeValues.size(), attributeId});
        }
        return filteredAttributeValues;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.logPrefix = null;
    }

    protected String getLogPrefix() {
        String result = this.logPrefix;
        if (null == result) {
            this.logPrefix = result = new StringBuffer("Attribute filtering engine '").append(this.getId()).append("' ").toString();
        }
        return result;
    }

    @Nonnull
    public AttributeFilter getComponent() {
        return this;
    }
}

