/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.matcher.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.filter.Matcher;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMatcher
extends AbstractIdentifiableInitializableComponent
implements Matcher {
    private final Logger log = LoggerFactory.getLogger(AbstractMatcher.class);
    private String logPrefix;

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.logPrefix = null;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Set<IdPAttributeValue<?>> getMatchingValues(@Nonnull IdPAttribute attribute, @Nonnull AttributeFilterContext filterContext) {
        HashSet<IdPAttributeValue> matchedValues = new HashSet<IdPAttributeValue>();
        this.log.debug("{} Applying value comparison to all values of Attribute '{}'", (Object)this.getLogPrefix(), (Object)attribute.getId());
        for (IdPAttributeValue value : attribute.getValues()) {
            if (!this.compareAttributeValue(value)) continue;
            matchedValues.add(value);
        }
        return Collections.unmodifiableSet(matchedValues);
    }

    protected abstract boolean compareAttributeValue(IdPAttributeValue var1);

    protected String getLogPrefix() {
        String prefix = this.logPrefix;
        if (null == prefix) {
            StringBuilder builder = new StringBuilder("Attribute Filter '").append(this.getId()).append("':");
            prefix = builder.toString();
            if (null == this.logPrefix) {
                this.logPrefix = prefix;
            }
        }
        return prefix;
    }
}

