/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.matcher.impl;

import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.filter.matcher.impl.AbstractMatcher;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;

public abstract class AbstractRegexpStringMatcher
extends AbstractMatcher {
    @NonnullAfterInit
    private Pattern regex;

    @NonnullAfterInit
    public String getRegularExpression() {
        return this.regex.pattern();
    }

    public void setRegularExpression(String expression) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.regex = Pattern.compile(expression);
    }

    protected boolean regexpCompare(@Nullable String value) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        if (this.regex == null || value == null) {
            return false;
        }
        return this.regex.matcher(value).matches();
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.regex) {
            throw new ComponentInitializationException(this.getLogPrefix() + " No regular expression provided");
        }
    }
}

