/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.matcher.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.filter.matcher.impl.AbstractStringMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeValueStringMatcher
extends AbstractStringMatcher {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeValueStringMatcher.class);

    @Override
    public boolean compareAttributeValue(@Nullable IdPAttributeValue value) {
        if (null == value) {
            return false;
        }
        if (value instanceof EmptyAttributeValue) {
            switch (((EmptyAttributeValue)value).getValue()) {
                case NULL_VALUE: {
                    return super.stringCompare(null);
                }
                case ZERO_LENGTH_VALUE: {
                    return super.stringCompare("");
                }
            }
            throw new IllegalArgumentException("Unknown empty attribute value type " + value.getValue());
        }
        if (value instanceof StringAttributeValue) {
            return super.stringCompare(((StringAttributeValue)value).getValue());
        }
        String valueAsString = value.getValue().toString();
        this.log.warn("{} Object supplied to StringAttributeValue comparison was of class {}, not StringAttributeValue, comparing with {}", new Object[]{this.getLogPrefix(), value.getClass().getName(), valueAsString});
        return super.stringCompare(valueAsString);
    }
}

