/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.matcher.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.filter.Matcher;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.component.UnmodifiableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.scripting.EvaluableScript;
import org.opensaml.messaging.context.navigate.ParentContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ScriptedMatcher
extends AbstractIdentifiableInitializableComponent
implements Matcher,
UnmodifiableComponent {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScriptedMatcher.class);
    @NonnullAfterInit
    private EvaluableScript script;
    @Nonnull
    private Function<AttributeFilterContext, ProfileRequestContext> prcLookupStrategy;
    private String logPrefix;
    @Nullable
    private Object customObject;

    public ScriptedMatcher(@Nonnull EvaluableScript matchingScript) {
        this.setScript(matchingScript);
        this.prcLookupStrategy = Functions.compose((Function)new ParentContextLookup(), (Function)new ParentContextLookup());
    }

    @Nullable
    public Object getCustomObject() {
        return this.customObject;
    }

    @Nullable
    public void setCustomObject(Object object) {
        this.customObject = object;
    }

    @Nonnull
    public EvaluableScript getScript() {
        return this.script;
    }

    protected void setScript(@Nonnull EvaluableScript matcherScript) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.script = (EvaluableScript)Constraint.isNotNull((Object)matcherScript, (String)"Attribute value matching script can not be null");
    }

    public void setProfileRequestContextLookupStrategy(@Nonnull Function<AttributeFilterContext, ProfileRequestContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.prcLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ProfileRequestContext lookup strategy cannot be null");
    }

    @Nullable
    @NonnullElements
    @Unmodifiable
    public Set<IdPAttributeValue<?>> getMatchingValues(@Nonnull IdPAttribute attribute, @Nonnull AttributeFilterContext filterContext) {
        Constraint.isNotNull((Object)attribute, (String)"Attribute to be filtered can not be null");
        Constraint.isNotNull((Object)filterContext, (String)"Attribute filter context can not be null");
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        EvaluableScript currentScript = this.script;
        SimpleScriptContext scriptContext = new SimpleScriptContext();
        scriptContext.setAttribute("filterContext", filterContext, 100);
        scriptContext.setAttribute("custom", this.getCustomObject(), 100);
        ProfileRequestContext prc = (ProfileRequestContext)this.prcLookupStrategy.apply((Object)filterContext);
        if (null == prc) {
            this.log.error("{} Could not locate ProfileRequestContext", (Object)this.getLogPrefix());
        }
        scriptContext.setAttribute("profileContext", prc, 100);
        scriptContext.setAttribute("attribute", attribute, 100);
        try {
            Object result = currentScript.eval((ScriptContext)scriptContext);
            if (null == result) {
                this.log.error("{} Matcher script did not return a result.", (Object)this.getLogPrefix());
                return null;
            }
            if (result instanceof Set) {
                HashSet returnValues = new HashSet(attribute.getValues());
                returnValues.retainAll((Set)result);
                return Collections.unmodifiableSet(returnValues);
            }
            this.log.error("{} Matcher script did not return a Set.", (Object)this.getLogPrefix());
            return null;
        }
        catch (ScriptException e) {
            this.log.error("{} Error while executing value matching script", (Object)this.getLogPrefix(), (Object)e);
            return null;
        }
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.logPrefix = null;
        if (null == this.script) {
            throw new ComponentInitializationException("No script has been provided");
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ScriptedMatcher)) {
            return false;
        }
        ScriptedMatcher other = (ScriptedMatcher)((Object)obj);
        return this.script.equals(other.getScript());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.script, this.getId()});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("Script", (Object)this.getScript()).toString();
    }

    protected String getLogPrefix() {
        String prefix = this.logPrefix;
        if (null == prefix) {
            StringBuilder builder = new StringBuilder("Scripted Attribute Filter '").append(this.getId()).append("':");
            prefix = builder.toString();
            if (null == this.logPrefix) {
                this.logPrefix = prefix;
            }
        }
        return prefix;
    }
}

