/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.matcher.logic.impl;

import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.filter.Matcher;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.attribute.filter.matcher.logic.impl.AbstractComposedMatcher;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;

@ThreadSafe
public class AndMatcher
extends AbstractComposedMatcher {
    public AndMatcher(@Nullable @NullableElements Collection<Matcher> composedMatchers) {
        super(composedMatchers);
    }

    @Nullable
    @NonnullElements
    public Set<IdPAttributeValue<?>> getMatchingValues(@Nonnull IdPAttribute attribute, @Nonnull AttributeFilterContext filterContext) {
        Constraint.isNotNull((Object)attribute, (String)"Attribute to be filtered can not be null");
        Constraint.isNotNull((Object)filterContext, (String)"Attribute filter context can not be null");
        List<Matcher> currentMatchers = this.getComposedMatchers();
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        Iterator<Matcher> matcherItr = currentMatchers.iterator();
        Set match = matcherItr.next().getMatchingValues(attribute, filterContext);
        if (null == match) {
            return null;
        }
        HashSet matchingValues = new HashSet(match);
        while (matcherItr.hasNext()) {
            match = matcherItr.next().getMatchingValues(attribute, filterContext);
            if (null == match) {
                return null;
            }
            matchingValues.retainAll(match);
            if (!matchingValues.isEmpty()) continue;
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(matchingValues);
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getComposedMatchers().isEmpty()) {
            throw new ComponentInitializationException("No matchers supplied to AND");
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("Composed Matchers : ", this.getComposedMatchers()).toString();
    }
}

