/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.matcher.logic.impl;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.filter.Matcher;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;

@ThreadSafe
public final class NotMatcher
extends AbstractIdentifiableInitializableComponent
implements Matcher {
    private final Matcher negatedMatcher;

    public NotMatcher(@Nonnull Matcher valueMatcher) {
        this.negatedMatcher = (Matcher)Constraint.isNotNull((Object)valueMatcher, (String)"Attribute value matcher can not be null");
    }

    @Nonnull
    public Matcher getNegatedMatcher() {
        return this.negatedMatcher;
    }

    @Nullable
    @NonnullElements
    public Set<IdPAttributeValue<?>> getMatchingValues(@Nonnull IdPAttribute attribute, @Nonnull AttributeFilterContext filterContext) {
        Constraint.isNotNull((Object)attribute, (String)"Attribute to be filtered can not be null");
        Constraint.isNotNull((Object)filterContext, (String)"Attribute filter context can not be null");
        Matcher currentMatcher = this.getNegatedMatcher();
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        HashSet attributeValues = new HashSet(attribute.getValues());
        Set matches = currentMatcher.getMatchingValues(attribute, filterContext);
        if (null == matches) {
            return matches;
        }
        attributeValues.removeAll(matches);
        if (attributeValues.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(attributeValues);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("negatedMatcher", (Object)this.negatedMatcher).toString();
    }
}

