/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.matcher.saml.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributeEncoder;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.filter.Matcher;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.saml.attribute.encoding.SAML1AttributeEncoder;
import net.shibboleth.idp.saml.attribute.encoding.SAML2AttributeEncoder;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSBase64Binary;
import org.opensaml.core.xml.schema.XSBoolean;
import org.opensaml.core.xml.schema.XSDateTime;
import org.opensaml.core.xml.schema.XSInteger;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.schema.XSURI;
import org.opensaml.saml.common.messaging.context.AttributeConsumingServiceContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.saml2.metadata.AttributeConsumingService;
import org.opensaml.saml.saml2.metadata.RequestedAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeInMetadataMatcher
extends AbstractIdentifiableInitializableComponent
implements Matcher {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeInMetadataMatcher.class);
    private boolean onlyIfRequired = true;
    private boolean matchIfMetadataSilent;
    private String attributeName;
    private String attributeNameFormat;
    private String logPrefix;

    public boolean getOnlyIfRequired() {
        return this.onlyIfRequired;
    }

    public void setOnlyIfRequired(boolean flag) {
        this.onlyIfRequired = flag;
    }

    public boolean getMatchIfMetadataSilent() {
        return this.matchIfMetadataSilent;
    }

    public void setMatchIfMetadataSilent(boolean flag) {
        this.matchIfMetadataSilent = flag;
    }

    @Nullable
    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(@Nullable String name) {
        this.attributeName = StringSupport.trimOrNull((String)name);
    }

    @Nullable
    public String getAttributeNameFormat() {
        return this.attributeNameFormat;
    }

    public void setAttributeNameFormat(@Nullable String format) {
        this.attributeNameFormat = StringSupport.trimOrNull((String)format);
        if (this.attributeNameFormat != null && "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified".equals(this.attributeNameFormat)) {
            this.attributeNameFormat = null;
        }
    }

    @Nonnull
    public Set<IdPAttributeValue<?>> getMatchingValues(@Nonnull IdPAttribute attribute, @Nonnull AttributeFilterContext filterContext) {
        String attributeToLog;
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        AttributeConsumingService service = this.getAttributeConsumingService(filterContext);
        if (null == service) {
            if (this.matchIfMetadataSilent) {
                this.log.debug("{} The peer's metadata did not contain requested attribute information, returning all the input values", (Object)this.getLogPrefix());
                return ImmutableSet.copyOf((Collection)attribute.getValues());
            }
            this.log.debug("{} The peer's metadata did not contain requested attribute information, returning no values", (Object)this.getLogPrefix());
            return Collections.emptySet();
        }
        RequestedAttribute requestedAttribute = null;
        if (this.attributeName != null) {
            this.log.debug("Looking for RequestedAttribute {} (NameFormat {}) in descriptor", (Object)this.attributeName, (Object)this.attributeNameFormat);
            requestedAttribute = this.findInMetadata(service, this.attributeName, this.attributeNameFormat);
        } else {
            AttributeEncoder encoder;
            Set encoders = attribute.getEncoders();
            Iterator i$ = encoders.iterator();
            while (i$.hasNext() && (requestedAttribute = this.findInMetadata(service, encoder = (AttributeEncoder)i$.next())) == null) {
            }
        }
        String string = attributeToLog = this.attributeName != null ? this.attributeName : attribute.getId();
        if (null == requestedAttribute) {
            this.log.debug("{} Attribute {} not found in metadata", (Object)this.getLogPrefix(), (Object)attributeToLog);
            return Collections.emptySet();
        }
        if (requestedAttribute != null && this.onlyIfRequired && !requestedAttribute.isRequired().booleanValue()) {
            this.log.debug("{} Attribute {} found in metadata, but was not required, values not matched", (Object)this.getLogPrefix(), (Object)attributeToLog);
            return Collections.emptySet();
        }
        HashSet values = new HashSet();
        values.addAll(this.filterValues(attributeToLog, attribute, requestedAttribute.getAttributeValues()));
        return values;
    }

    @Nullable
    private AttributeConsumingService getAttributeConsumingService(@Nonnull AttributeFilterContext filterContext) {
        SAMLMetadataContext metadataContext = filterContext.getRequesterMetadataContext();
        if (null == metadataContext) {
            this.log.warn("{} No metadata context when filtering", (Object)this.getLogPrefix());
            return null;
        }
        AttributeConsumingServiceContext acsContext = (AttributeConsumingServiceContext)metadataContext.getSubcontext(AttributeConsumingServiceContext.class);
        return acsContext != null ? acsContext.getAttributeConsumingService() : null;
    }

    @Nullable
    private RequestedAttribute findInMetadata(@Nonnull AttributeConsumingService service, @Nonnull AttributeEncoder encoder) {
        String name = null;
        String qualifier = null;
        if (encoder instanceof SAML2AttributeEncoder) {
            name = ((SAML2AttributeEncoder)encoder).getName();
            qualifier = ((SAML2AttributeEncoder)encoder).getNameFormat();
        } else if (encoder instanceof SAML1AttributeEncoder) {
            name = ((SAML1AttributeEncoder)encoder).getName();
            qualifier = ((SAML1AttributeEncoder)encoder).getNamespace();
        }
        return this.findInMetadata(service, name, qualifier);
    }

    @Nullable
    private RequestedAttribute findInMetadata(@Nonnull AttributeConsumingService service, @Nonnull String name, @Nullable String nameFormat) {
        List requested = service.getRequestAttributes();
        for (RequestedAttribute attr : requested) {
            if (!attr.getName().equals(name)) continue;
            String format = attr.getNameFormat();
            if (nameFormat != null && format != null && !format.equals("urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified") && !nameFormat.equals(format)) continue;
            return attr;
        }
        return null;
    }

    @Nonnull
    private Set<IdPAttributeValue<?>> filterValues(@Nonnull String attributeToLog, @Nullable IdPAttribute attribute, @Nonnull @NonnullElements List<XMLObject> requestedValues) {
        if (requestedValues.isEmpty()) {
            this.log.debug("{} Attribute {} found in metadata and no values specified", (Object)this.getLogPrefix(), (Object)attributeToLog);
            return ImmutableSet.copyOf((Collection)attribute.getValues());
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (IdPAttributeValue attributeValue : attribute.getValues()) {
            if (attributeValue instanceof StringAttributeValue) {
                for (XMLObject xmlObj : requestedValues) {
                    if (!this.match(xmlObj, ((StringAttributeValue)attributeValue).getValue())) continue;
                    builder.add((Object)attributeValue);
                }
                continue;
            }
            this.log.warn("{} Attribute {} value not a simple string, can't match against values in metadata", (Object)this.getLogPrefix(), (Object)attribute.getId());
        }
        ImmutableSet result = builder.build();
        this.log.debug("{} Values matched with metadata for Attribute {} : {}", new Object[]{this.getLogPrefix(), attributeToLog, result});
        return result;
    }

    private boolean match(XMLObject xmlObj, String attributeValue) {
        XSAny wc;
        String toMatch = null;
        if (xmlObj instanceof XSString) {
            toMatch = ((XSString)xmlObj).getValue();
        } else if (xmlObj instanceof XSURI) {
            toMatch = ((XSURI)xmlObj).getValue();
        } else if (xmlObj instanceof XSBoolean) {
            toMatch = ((XSBoolean)xmlObj).getValue().getValue() != false ? "1" : "0";
        } else if (xmlObj instanceof XSInteger) {
            toMatch = ((XSInteger)xmlObj).getValue().toString();
        } else if (xmlObj instanceof XSDateTime) {
            DateTime dt = ((XSDateTime)xmlObj).getValue();
            if (dt != null) {
                toMatch = ((XSDateTime)xmlObj).getDateTimeFormatter().print((ReadableInstant)dt);
            }
        } else if (xmlObj instanceof XSBase64Binary) {
            toMatch = ((XSBase64Binary)xmlObj).getValue();
        } else if (xmlObj instanceof XSAny && (wc = (XSAny)xmlObj).getUnknownAttributes().isEmpty() && wc.getUnknownXMLObjects().isEmpty()) {
            toMatch = wc.getTextContent();
        }
        if (toMatch != null) {
            return toMatch.equals(attributeValue);
        }
        this.log.warn("Unrecognized XMLObject type, unable to match as a string to candidate value");
        return false;
    }

    @Nonnull
    protected String getLogPrefix() {
        String prefix = this.logPrefix;
        if (null == prefix) {
            StringBuilder builder = new StringBuilder("Attribute Filter '").append(this.getId()).append("':");
            prefix = builder.toString();
            if (null == this.logPrefix) {
                this.logPrefix = prefix;
            }
        }
        return prefix;
    }
}

