/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.matcher.saml.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.IdPRequestedAttribute;
import net.shibboleth.idp.attribute.filter.Matcher;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.saml.attribute.mapping.AttributesMapContainer;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.saml.common.messaging.context.AttributeConsumingServiceContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.navigate.AttributeConsumerServiceLookupFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappedAttributeInMetadataMatcher
extends AbstractIdentifiableInitializableComponent
implements Matcher {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(MappedAttributeInMetadataMatcher.class);
    private boolean onlyIfRequired = true;
    private boolean matchIfMetadataSilent;
    private String logPrefix;
    @Nonnull
    private Function<SAMLMetadataContext, ? extends XMLObject> objectStrategy = Functions.compose((Function)new AttributeConsumerServiceLookupFunction(), (Function)new ChildContextLookup(AttributeConsumingServiceContext.class));

    public boolean getOnlyIfRequired() {
        return this.onlyIfRequired;
    }

    public void setOnlyIfRequired(boolean flag) {
        this.onlyIfRequired = flag;
    }

    public Function<SAMLMetadataContext, ? extends XMLObject> getXMLObjectStrategy() {
        return this.objectStrategy;
    }

    public void setObjectStrategy(@Nonnull Function<SAMLMetadataContext, ? extends XMLObject> strategy) {
        this.objectStrategy = (Function)Constraint.isNotNull(strategy, (String)"ObjectStrategy must be non null");
    }

    public boolean getMatchIfMetadataSilent() {
        return this.matchIfMetadataSilent;
    }

    public void setMatchIfMetadataSilent(boolean flag) {
        this.matchIfMetadataSilent = flag;
    }

    @Nullable
    protected Multimap<String, ? extends IdPAttribute> getRequestedAttributes(@Nonnull AttributeFilterContext filterContext) {
        SAMLMetadataContext metadataContext = filterContext.getRequesterMetadataContext();
        if (null == metadataContext) {
            this.log.warn("{} No metadata context when filtering", (Object)this.getLogPrefix());
            return null;
        }
        XMLObject xmlObject = (XMLObject)this.getXMLObjectStrategy().apply((Object)metadataContext);
        if (null == xmlObject) {
            this.log.warn("{} No RP XML Object found when filtering", (Object)this.getLogPrefix());
            return null;
        }
        List containerList = xmlObject.getObjectMetadata().get(AttributesMapContainer.class);
        if (null == containerList || containerList.isEmpty()) {
            this.log.debug("{} No mapped attributes found when filtering", (Object)this.getLogPrefix());
            return null;
        }
        if (containerList.size() > 1) {
            this.log.warn("{} More than one set of mapped attributes found when filtering, please report an error", (Object)this.getLogPrefix());
        }
        return ((AttributesMapContainer)containerList.get(0)).get();
    }

    @Nonnull
    public Set<IdPAttributeValue<?>> getMatchingValues(@Nonnull IdPAttribute attribute, @Nonnull AttributeFilterContext filterContext) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        Multimap<String, ? extends IdPAttribute> requestedAttributes = this.getRequestedAttributes(filterContext);
        if (null == requestedAttributes || requestedAttributes.isEmpty()) {
            if (this.matchIfMetadataSilent) {
                this.log.debug("{} The peer's metadata did not have appropriate requested attributes available, returning all the input values", (Object)this.getLogPrefix());
                return ImmutableSet.copyOf((Collection)attribute.getValues());
            }
            this.log.debug("{} The peer's metadata did not have appropriate requested attributes available, returning no values", (Object)this.getLogPrefix());
            return Collections.emptySet();
        }
        Collection requestedAttributeList = requestedAttributes.get((Object)attribute.getId());
        if (null == requestedAttributeList) {
            this.log.debug("{} Attribute {} not found in metadata", (Object)this.getLogPrefix(), (Object)attribute.getId());
            return Collections.emptySet();
        }
        HashSet values = new HashSet();
        for (IdPAttribute requestedAttribute : requestedAttributeList) {
            if (null == requestedAttribute) {
                this.log.info("{} Attribute {} found in metadata but with no values that could be decoded, values not matched", (Object)this.getLogPrefix(), (Object)attribute.getId());
                continue;
            }
            if (requestedAttribute instanceof IdPRequestedAttribute && !((IdPRequestedAttribute)requestedAttribute).getIsRequired() && this.onlyIfRequired) {
                this.log.debug("{} Attribute {} found in metadata, but was not required, values not matched", (Object)this.getLogPrefix(), (Object)attribute.getId());
                continue;
            }
            values.addAll(this.filterValues(attribute, requestedAttribute.getValues()));
        }
        return values;
    }

    @Nonnull
    private Set<IdPAttributeValue<?>> filterValues(@Nullable IdPAttribute attribute, @Nonnull @NonnullElements List<? extends IdPAttributeValue> requestedValues) {
        if (null == requestedValues || requestedValues.isEmpty()) {
            this.log.debug("{} Attribute {} found in metadata and no values specified", (Object)this.getLogPrefix(), (Object)attribute.getId());
            return ImmutableSet.copyOf((Collection)attribute.getValues());
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (IdPAttributeValue attributeValue : attribute.getValues()) {
            if (!requestedValues.contains(attributeValue)) continue;
            builder.add((Object)attributeValue);
        }
        ImmutableSet result = builder.build();
        this.log.debug("{} Values matched with metadata for Attribute {} : {}", new Object[]{this.getLogPrefix(), attribute.getId(), result});
        return result;
    }

    @Nonnull
    protected String getLogPrefix() {
        String prefix = this.logPrefix;
        if (null == prefix) {
            StringBuilder builder = new StringBuilder("Attribute Filter '").append(this.getId()).append("':");
            prefix = builder.toString();
            if (null == this.logPrefix) {
                this.logPrefix = prefix;
            }
        }
        return prefix;
    }
}

