/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.policyrule.filtercontext.impl;

import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.filter.PolicyRequirementRule;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.attribute.filter.policyrule.impl.AbstractRegexpPolicyRule;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationMethodRegexpPolicyRule
extends AbstractRegexpPolicyRule {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AuthenticationMethodRegexpPolicyRule.class);

    public PolicyRequirementRule.Tristate matches(@Nonnull AttributeFilterContext filterContext) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        String method = filterContext.getPrincipalAuthenticationMethod();
        if (null == method) {
            this.log.warn("{} No authetication method found for comparison", (Object)this.getLogPrefix());
            return PolicyRequirementRule.Tristate.FAIL;
        }
        this.log.debug("{} Found authentication method: {}", (Object)this.getLogPrefix(), (Object)method);
        return this.regexpCompare(method);
    }
}

