/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.policyrule.filtercontext.impl;

import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.filter.PolicyRequirementRule;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.attribute.filter.policyrule.impl.AbstractPolicyRule;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumOfAttributeValuesPolicyRule
extends AbstractPolicyRule {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(NumOfAttributeValuesPolicyRule.class);
    @NonnullAfterInit
    private String attributeId;
    private int minimumValues = -1;
    private int maximumValues = -1;

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.attributeId) {
            throw new ComponentInitializationException(this.getLogPrefix() + " No AttributeID specified");
        }
        if (this.minimumValues < 0) {
            throw new ComponentInitializationException(this.getLogPrefix() + " A minimum value >= 0 must be specified");
        }
        if (this.maximumValues <= 0) {
            throw new ComponentInitializationException(this.getLogPrefix() + " A maximum value > 0 must be specified");
        }
    }

    @Nonnull
    public PolicyRequirementRule.Tristate matches(@Nonnull AttributeFilterContext filterContext) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        IdPAttribute attribute = (IdPAttribute)filterContext.getPrefilteredIdPAttributes().get(this.attributeId);
        if (null == attribute) {
            this.log.warn("{} Attribute {} not found", (Object)this.getLogPrefix(), (Object)this.attributeId);
            return PolicyRequirementRule.Tristate.FALSE;
        }
        int numOfValues = attribute.getValues().size();
        boolean result = numOfValues >= this.minimumValues && numOfValues <= this.maximumValues;
        this.log.debug("{} Attribute {} has {} values, returning {}", new Object[]{this.getLogPrefix(), this.attributeId, numOfValues, result});
        if (result) {
            return PolicyRequirementRule.Tristate.TRUE;
        }
        return PolicyRequirementRule.Tristate.FALSE;
    }

    @NonnullAfterInit
    public String getAttributeId() {
        return this.attributeId;
    }

    public void setAttributeId(@Nonnull @NotEmpty String attribute) {
        this.attributeId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)attribute), (String)"attributeID must be nonempty");
    }

    public int getMinimum() {
        return this.minimumValues;
    }

    public void setMinimum(int minValues) {
        this.minimumValues = (int)Constraint.isGreaterThanOrEqual((long)0L, (long)minValues, (String)"min value must be >= 0");
    }

    public int getMaximum() {
        return this.maximumValues;
    }

    public void setMaximum(int maxValues) {
        this.maximumValues = (int)Constraint.isGreaterThan((long)0L, (long)maxValues, (String)"max value must be > 0");
    }
}

