/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.policyrule.filtercontext.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.filter.PolicyRequirementRule;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.attribute.filter.policyrule.impl.AbstractPolicyRule;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ParentContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PredicatePolicyRule
extends AbstractPolicyRule {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PredicatePolicyRule.class);
    @NonnullAfterInit
    private Predicate<ProfileRequestContext> rulePredicate;
    @Nonnull
    private Function<AttributeFilterContext, ProfileRequestContext> profileContextStrategy = Functions.compose((Function)new ParentContextLookup(), (Function)new ParentContextLookup());

    public Predicate<ProfileRequestContext> getRulePredicate() {
        return this.rulePredicate;
    }

    public void setRulePredicate(Predicate<ProfileRequestContext> predicate) {
        this.rulePredicate = predicate;
    }

    public Function<AttributeFilterContext, ProfileRequestContext> getProfileContextStrategy() {
        return this.profileContextStrategy;
    }

    public void setProfileContextStrategy(Function<AttributeFilterContext, ProfileRequestContext> strategy) {
        this.profileContextStrategy = (Function)Constraint.isNotNull(strategy, (String)"ProfileContext lookup strategy cannot be null");
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.getRulePredicate()) {
            this.log.error("{} Provided Rule Predicate was null", (Object)this.getLogPrefix());
            throw new ComponentInitializationException("Provided Rule Predicate was null");
        }
    }

    public PolicyRequirementRule.Tristate matches(@Nonnull AttributeFilterContext filterContext) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ProfileRequestContext pc = (ProfileRequestContext)this.profileContextStrategy.apply((Object)filterContext);
        if (null == pc) {
            this.log.warn("{} Could not locate profile context", (Object)this.getLogPrefix());
            return PolicyRequirementRule.Tristate.FAIL;
        }
        try {
            if (this.rulePredicate.apply((Object)pc)) {
                this.log.trace("{} Predicate returned false", (Object)this.getLogPrefix());
                return PolicyRequirementRule.Tristate.TRUE;
            }
            this.log.trace("{} Predicate returned false", (Object)this.getLogPrefix());
            return PolicyRequirementRule.Tristate.FALSE;
        }
        catch (Throwable ex) {
            this.log.warn("{} Applying the predicated failed", (Object)this.getLogPrefix(), (Object)ex);
            return PolicyRequirementRule.Tristate.FAIL;
        }
    }
}

