/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.policyrule.impl;

import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.filter.PolicyRequirementRule;
import net.shibboleth.idp.attribute.filter.policyrule.impl.AbstractPolicyRule;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;

public abstract class AbstractRegexpPolicyRule
extends AbstractPolicyRule {
    private Pattern regex;

    @NonnullAfterInit
    public String getRegularExpression() {
        return this.regex.pattern();
    }

    public void setRegularExpression(String expression) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.regex = Pattern.compile(expression);
    }

    protected PolicyRequirementRule.Tristate regexpCompare(@Nullable String value) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        boolean result = this.regex == null || value == null ? false : this.regex.matcher(value).matches();
        if (result) {
            return PolicyRequirementRule.Tristate.TRUE;
        }
        return PolicyRequirementRule.Tristate.FALSE;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.regex) {
            throw new ComponentInitializationException(this.getLogPrefix() + " No regular expression provided");
        }
    }
}

