/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.policyrule.logic.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.filter.PolicyRequirementRule;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.collection.CollectionSupport;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.UnmodifiableComponent;

public abstract class AbstractComposedPolicyRule
extends AbstractIdentifiableInitializableComponent
implements PolicyRequirementRule,
UnmodifiableComponent {
    private final List<PolicyRequirementRule> rules;

    public AbstractComposedPolicyRule(@Nullable @NullableElements Collection<PolicyRequirementRule> theRules) {
        ArrayList checkedMatchers = new ArrayList();
        if (theRules != null) {
            CollectionSupport.addIf(checkedMatchers, theRules, (Predicate)Predicates.notNull());
        }
        this.rules = ImmutableList.copyOf((Iterable)Iterables.filter(checkedMatchers, (Predicate)Predicates.notNull()));
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public List<PolicyRequirementRule> getComposedRules() {
        return this.rules;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("Composed Rules : ", this.getComposedRules()).toString();
    }
}

