/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.policyrule.logic.impl;

import com.google.common.base.MoreObjects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.filter.PolicyRequirementRule;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;

@ThreadSafe
public final class NotPolicyRule
extends AbstractIdentifiableInitializableComponent
implements PolicyRequirementRule {
    private final PolicyRequirementRule negatedRule;

    public NotPolicyRule(@Nonnull PolicyRequirementRule rule) {
        this.negatedRule = (PolicyRequirementRule)Constraint.isNotNull((Object)rule, (String)"Policy Requirement rule can not be null");
    }

    @Nonnull
    public PolicyRequirementRule getNegatedRule() {
        return this.negatedRule;
    }

    public PolicyRequirementRule.Tristate matches(@Nonnull AttributeFilterContext filterContext) {
        Constraint.isNotNull((Object)filterContext, (String)"Attribute filter context can not be null");
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        PolicyRequirementRule.Tristate match = this.negatedRule.matches(filterContext);
        if (PolicyRequirementRule.Tristate.FAIL == match) {
            return PolicyRequirementRule.Tristate.FAIL;
        }
        if (PolicyRequirementRule.Tristate.FALSE == match) {
            return PolicyRequirementRule.Tristate.TRUE;
        }
        return PolicyRequirementRule.Tristate.FALSE;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("Negated Policy Rule", (Object)this.negatedRule).toString();
    }
}

