/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.policyrule.logic.impl;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.filter.PolicyRequirementRule;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.attribute.filter.policyrule.logic.impl.AbstractComposedPolicyRule;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;

@ThreadSafe
public class OrPolicyRule
extends AbstractComposedPolicyRule {
    public OrPolicyRule(@Nullable @NullableElements Collection<PolicyRequirementRule> composedMatchers) {
        super(composedMatchers);
    }

    public PolicyRequirementRule.Tristate matches(@Nonnull AttributeFilterContext filterContext) {
        Constraint.isNotNull((Object)filterContext, (String)"Attribute filter context can not be null");
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        List<PolicyRequirementRule> rules = this.getComposedRules();
        for (PolicyRequirementRule rule : rules) {
            PolicyRequirementRule.Tristate match = rule.matches(filterContext);
            if (PolicyRequirementRule.Tristate.FAIL == match) {
                return PolicyRequirementRule.Tristate.FAIL;
            }
            if (PolicyRequirementRule.Tristate.TRUE != match) continue;
            return PolicyRequirementRule.Tristate.TRUE;
        }
        return PolicyRequirementRule.Tristate.FALSE;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getComposedRules().isEmpty()) {
            throw new ComponentInitializationException("No policy rules supplied to OR");
        }
    }
}

