/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.policyrule.saml.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.filter.PolicyRequirementRule;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.attribute.filter.policyrule.impl.AbstractPolicyRule;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.saml.ext.saml2mdattr.EntityAttributes;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEntityAttributePolicyRule
extends AbstractPolicyRule {
    private final Logger log = LoggerFactory.getLogger(AbstractEntityAttributePolicyRule.class);
    private String attrName;
    private String nameFormat;

    @NonnullAfterInit
    public String getAttributeName() {
        return this.attrName;
    }

    public void setAttributeName(@Nullable String attributeName) {
        this.attrName = StringSupport.trimOrNull((String)attributeName);
    }

    @Nullable
    public String getNameFormat() {
        return this.nameFormat;
    }

    public void setNameFormat(@Nullable String attributeNameFormat) {
        this.nameFormat = StringSupport.trimOrNull((String)attributeNameFormat);
    }

    public PolicyRequirementRule.Tristate matches(@Nonnull AttributeFilterContext filterContext) {
        Constraint.isNotNull((Object)filterContext, (String)"Context must be supplied");
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        EntityDescriptor entityDescriptor = this.getEntityMetadata(filterContext);
        if (entityDescriptor == null) {
            this.log.info("{} No metadata available for the entity, returning FALSE", (Object)this.getLogPrefix());
            return PolicyRequirementRule.Tristate.FALSE;
        }
        List<XMLObject> attributeValues = this.getEntityAttributeValues(entityDescriptor);
        if (attributeValues == null || attributeValues.isEmpty()) {
            this.log.debug("{} Entity attribute {} for entity {} does not exist or contains no values, returning FALSE", new Object[]{this.getLogPrefix(), this.getAttributeName(), entityDescriptor.getEntityID()});
            return PolicyRequirementRule.Tristate.FALSE;
        }
        this.log.debug("{} Checking if entity attribute {} contains the required value.", (Object)this.getLogPrefix(), (Object)this.getAttributeName());
        for (XMLObject attributeValue : attributeValues) {
            String valueString;
            if (attributeValue instanceof XSAny) {
                valueString = ((XSAny)attributeValue).getTextContent();
            } else if (attributeValue instanceof XSString) {
                valueString = ((XSString)attributeValue).getValue();
            } else {
                this.log.debug("{} Entity attribute {} contains the unsupported value type {}, skipping it", new Object[]{this.getLogPrefix(), this.getAttributeName(), attributeValue.getClass().getName()});
                continue;
            }
            if (valueString == null) continue;
            if (this.entityAttributeValueMatches(valueString)) {
                this.log.debug("{} Entity attribute {} value {} meets matching requirements", new Object[]{this.getLogPrefix(), this.getAttributeName(), valueString});
                return PolicyRequirementRule.Tristate.TRUE;
            }
            this.log.debug("{} Entity attribute {} value {} does not meet matching requirements", new Object[]{this.getLogPrefix(), this.getAttributeName(), valueString});
        }
        return PolicyRequirementRule.Tristate.FALSE;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.attrName == null) {
            throw new ComponentInitializationException(this.getLogPrefix() + " Attribute name is null");
        }
    }

    @Nullable
    protected abstract EntityDescriptor getEntityMetadata(AttributeFilterContext var1);

    protected abstract boolean entityAttributeValueMatches(String var1);

    @Nullable
    @NotEmpty
    @NonnullElements
    private List<XMLObject> getEntityAttributeValues(@Nonnull EntityDescriptor entityDescriptor) {
        List entityAttributes;
        ArrayList valueAccumulator = null;
        List entityAttributesCollection = null;
        if (entityDescriptor.getExtensions() != null) {
            entityAttributesCollection = entityDescriptor.getExtensions().getUnknownXMLObjects(EntityAttributes.DEFAULT_ELEMENT_NAME);
        }
        if (entityAttributesCollection == null || entityAttributesCollection.isEmpty()) {
            this.log.debug("{} EntityDescriptor for {} does not contain any EntityAttributes", (Object)this.getLogPrefix(), (Object)entityDescriptor.getEntityID());
            return null;
        }
        if (entityAttributesCollection.size() > 1) {
            this.log.debug("{} EntityDescriptor for {} contains more than one EntityAttributes extension, only using the first one", (Object)this.getLogPrefix(), (Object)entityDescriptor.getEntityID());
        }
        if ((entityAttributes = ((EntityAttributes)entityAttributesCollection.get(0)).getAttributes()) == null || entityAttributes.isEmpty()) {
            this.log.debug("{} EntityAttributes extension for {} does not contain any Attributes", (Object)this.getLogPrefix(), (Object)entityDescriptor.getEntityID());
            return null;
        }
        for (Attribute entityAttribute : entityAttributes) {
            if (!Objects.equals(this.getAttributeName(), entityAttribute.getName()) || this.getNameFormat() != null && !Objects.equals(this.getNameFormat(), entityAttribute.getNameFormat())) continue;
            this.log.debug("{} EntityDescriptor for {} contains an entity attribute with the name {} and the format {}", new Object[]{this.getLogPrefix(), entityDescriptor.getEntityID(), this.getAttributeName(), this.getNameFormat()});
            if (valueAccumulator == null) {
                valueAccumulator = new ArrayList();
            }
            valueAccumulator.addAll(entityAttribute.getAttributeValues());
        }
        if (valueAccumulator != null && !valueAccumulator.isEmpty()) {
            return valueAccumulator;
        }
        this.log.debug("{} EntityDescriptor for {} does not contain entity attribute with the name {} and the format {}", new Object[]{this.getLogPrefix(), entityDescriptor.getEntityID(), this.getAttributeName(), this.getNameFormat()});
        return null;
    }
}

