/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.policyrule.saml.impl;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.attribute.filter.policyrule.saml.impl.AbstractEntityAttributePolicyRule;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeRequesterEntityAttributeExactPolicyRule
extends AbstractEntityAttributePolicyRule {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeRequesterEntityAttributeExactPolicyRule.class);
    @NonnullAfterInit
    private String value;

    @NonnullAfterInit
    public String getValue() {
        return this.value;
    }

    public void setValue(@Nonnull String attributeValue) {
        this.value = (String)Constraint.isNotNull((Object)attributeValue, (String)"Attribute value cannot be null.");
    }

    @Override
    protected boolean entityAttributeValueMatches(@Nullable String stringValue) {
        return Objects.equals(this.value, stringValue);
    }

    @Override
    @Nullable
    protected EntityDescriptor getEntityMetadata(AttributeFilterContext filterContext) {
        SAMLMetadataContext metadataContext = filterContext.getRequesterMetadataContext();
        if (null == metadataContext) {
            this.log.warn("{} Could not locate SP metadata context", (Object)this.getLogPrefix());
            return null;
        }
        return metadataContext.getEntityDescriptor();
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.value) {
            throw new ComponentInitializationException(this.getLogPrefix() + " No value supplied to compare against");
        }
    }
}

