/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.policyrule.saml.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.attribute.filter.policyrule.saml.impl.AbstractEntityAttributePolicyRule;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeRequesterEntityAttributeRegexPolicyRule
extends AbstractEntityAttributePolicyRule {
    private final Logger log = LoggerFactory.getLogger(AttributeRequesterEntityAttributeRegexPolicyRule.class);
    private Pattern valueRegex;

    @NonnullAfterInit
    public Pattern getValueRegex() {
        return this.valueRegex;
    }

    public void setValueRegex(Pattern attributeValueRegex) {
        this.valueRegex = attributeValueRegex;
    }

    @Override
    protected boolean entityAttributeValueMatches(String entityAttributeValue) {
        Matcher valueMatcher = this.valueRegex.matcher(StringSupport.trim((String)entityAttributeValue));
        return valueMatcher.matches();
    }

    @Override
    @Nullable
    protected EntityDescriptor getEntityMetadata(AttributeFilterContext filterContext) {
        SAMLMetadataContext metadataContext = filterContext.getRequesterMetadataContext();
        if (null == metadataContext) {
            this.log.warn("{} Could not locate SP metadata context", (Object)this.getLogPrefix());
            return null;
        }
        return metadataContext.getEntityDescriptor();
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.valueRegex == null) {
            throw new ComponentInitializationException(this.getLogPrefix() + " No regexp supplied to compare with");
        }
    }
}

