/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.policyrule.saml.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.filter.PolicyRequirementRule;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.attribute.filter.policyrule.impl.AbstractPolicyRule;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.metadata.EntityGroupName;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeRequesterInEntityGroupPolicyRule
extends AbstractPolicyRule {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeRequesterInEntityGroupPolicyRule.class);
    @Nullable
    private String entityGroup;

    @Nullable
    public String getEntityGroup() {
        return this.entityGroup;
    }

    public void setEntityGroup(@Nullable String group) {
        this.entityGroup = StringSupport.trimOrNull((String)group);
    }

    @Nullable
    protected EntityDescriptor getEntityMetadata(@Nonnull AttributeFilterContext filterContext) {
        SAMLMetadataContext metadataContext = filterContext.getRequesterMetadataContext();
        if (null == metadataContext) {
            this.log.warn("{} Could not locate SP metadata context", (Object)this.getLogPrefix());
            return null;
        }
        return metadataContext.getEntityDescriptor();
    }

    @Nonnull
    public PolicyRequirementRule.Tristate matches(@Nonnull AttributeFilterContext input) {
        Constraint.isNotNull((Object)input, (String)"Context must be supplied");
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        if (this.entityGroup == null) {
            this.log.warn("{} No entity group specified, unable to check if entity is in group", (Object)this.getLogPrefix());
            return PolicyRequirementRule.Tristate.FALSE;
        }
        EntityDescriptor entity = this.getEntityMetadata(input);
        if (entity == null) {
            return PolicyRequirementRule.Tristate.FALSE;
        }
        for (EntityGroupName group : entity.getObjectMetadata().get(EntityGroupName.class)) {
            if (!group.getName().equals(this.entityGroup)) continue;
            return PolicyRequirementRule.Tristate.TRUE;
        }
        return PolicyRequirementRule.Tristate.FALSE;
    }
}

