/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.policyrule.saml.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.filter.PolicyRequirementRule;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.attribute.filter.policyrule.impl.AbstractPolicyRule;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.saml2.metadata.NameIDFormat;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SSODescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeRequesterNameIDFormatExactPolicyRule
extends AbstractPolicyRule {
    private final Logger log = LoggerFactory.getLogger(AttributeRequesterNameIDFormatExactPolicyRule.class);
    private String nameIdFormat;

    @NonnullAfterInit
    public String getNameIdFormat() {
        return this.nameIdFormat;
    }

    public void setNameIdFormat(String format) {
        this.nameIdFormat = StringSupport.trimOrNull((String)format);
    }

    @Nullable
    protected SSODescriptor getEntitySSODescriptor(AttributeFilterContext filterContext) {
        SAMLMetadataContext metadataContext = filterContext.getRequesterMetadataContext();
        if (null == metadataContext) {
            this.log.warn("{} Could not locate SP metadata context", (Object)this.getLogPrefix());
            return null;
        }
        RoleDescriptor role = metadataContext.getRoleDescriptor();
        if (null == role) {
            this.log.warn("{} Could not locate RoleDescriptor in SP metadata", (Object)this.getLogPrefix());
            return null;
        }
        if (role instanceof SSODescriptor) {
            return (SSODescriptor)role;
        }
        this.log.warn("{} Located Role descriptor was of type {} and so could not be used", (Object)this.getLogPrefix(), (Object)role.getClass().toString());
        return null;
    }

    public PolicyRequirementRule.Tristate matches(@Nonnull AttributeFilterContext filterContext) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        SSODescriptor role = this.getEntitySSODescriptor(filterContext);
        if (role == null) {
            return PolicyRequirementRule.Tristate.FALSE;
        }
        List supportedFormats = role.getNameIDFormats();
        if (supportedFormats == null || supportedFormats.isEmpty()) {
            this.log.debug("{} Entity SSO role descriptor does not list any supported NameID formats", (Object)this.getLogPrefix());
            return PolicyRequirementRule.Tristate.FALSE;
        }
        for (NameIDFormat supportedFormat : supportedFormats) {
            if (!this.nameIdFormat.equals(supportedFormat.getFormat())) continue;
            this.log.debug("{} Entity does support the NameID format '{}'", (Object)this.getLogPrefix(), (Object)this.nameIdFormat);
            return PolicyRequirementRule.Tristate.TRUE;
        }
        this.log.debug("{} Entity does not support the NameID format '{}'", (Object)this.getLogPrefix(), (Object)this.nameIdFormat);
        return PolicyRequirementRule.Tristate.FALSE;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.nameIdFormat) {
            throw new ComponentInitializationException(this.getLogPrefix() + " No NameID format specified");
        }
    }
}

