/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.policyrule.saml.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.filter.PolicyRequirementRule;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.attribute.filter.policyrule.impl.AbstractPolicyRule;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.ext.saml2mdrpi.RegistrationInfo;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistrationAuthorityPolicyRule
extends AbstractPolicyRule {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(RegistrationAuthorityPolicyRule.class);
    @Nonnull
    @NonnullElements
    private Set<String> issuers;
    private boolean matchIfMetadataSilent;

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public Set<String> getIssuers() {
        return ImmutableSet.copyOf(this.issuers);
    }

    public void setIssuers(@Nonnull @NonnullElements Collection<String> theIssuers) {
        Constraint.isNotNull(theIssuers, (String)"Issuer collection cannot be null");
        this.issuers = new HashSet<String>(theIssuers.size());
        for (String s : theIssuers) {
            String trimmed = StringSupport.trimOrNull((String)s);
            if (trimmed == null) continue;
            this.issuers.add(trimmed);
        }
    }

    public boolean isMatchIfMetadataSilent() {
        return this.matchIfMetadataSilent;
    }

    public void setMatchIfMetadataSilent(boolean value) {
        this.matchIfMetadataSilent = value;
    }

    @Nullable
    private RegistrationInfo getRegistrationInfo(@Nonnull AttributeFilterContext filterContext) {
        SAMLMetadataContext metadataContext = filterContext.getRequesterMetadataContext();
        if (null == metadataContext) {
            this.log.debug("{} Filtering on registration, but no metadata context available", (Object)this.getLogPrefix());
            return null;
        }
        EntityDescriptor spEntity = metadataContext.getEntityDescriptor();
        if (null == spEntity) {
            this.log.debug("Filtering on registration, but no peer metadata available");
            return null;
        }
        Extensions extensions = spEntity.getExtensions();
        if (null != extensions) {
            for (XMLObject object : extensions.getUnknownXMLObjects(RegistrationInfo.DEFAULT_ELEMENT_NAME)) {
                if (!(object instanceof RegistrationInfo)) continue;
                return (RegistrationInfo)object;
            }
        }
        for (EntitiesDescriptor group = (EntitiesDescriptor)spEntity.getParent(); null != group; group = (EntitiesDescriptor)group.getParent()) {
            extensions = group.getExtensions();
            if (null == extensions) continue;
            for (XMLObject object : extensions.getUnknownXMLObjects(RegistrationInfo.DEFAULT_ELEMENT_NAME)) {
                if (!(object instanceof RegistrationInfo)) continue;
                return (RegistrationInfo)object;
            }
        }
        this.log.debug("{} Filtering on registration, but no RegistrationInfo available", (Object)this.getLogPrefix());
        return null;
    }

    public PolicyRequirementRule.Tristate matches(@Nonnull AttributeFilterContext filterContext) {
        RegistrationInfo info = this.getRegistrationInfo(filterContext);
        if (info == null) {
            this.log.debug("{} The peer's metadata did not contain a RegistrationInfo descriptor", (Object)this.getLogPrefix());
            if (this.matchIfMetadataSilent) {
                return PolicyRequirementRule.Tristate.TRUE;
            }
            return PolicyRequirementRule.Tristate.FALSE;
        }
        String authority = info.getRegistrationAuthority();
        this.log.debug("{} Peer's metadata has registration authority: {}", (Object)this.getLogPrefix(), (Object)authority);
        if (this.issuers.contains(authority)) {
            this.log.debug("{} Peer's metadata registration authority matches", (Object)this.getLogPrefix());
            return PolicyRequirementRule.Tristate.TRUE;
        }
        this.log.debug("{} Peer's metadata registration authority does not match", (Object)this.getLogPrefix());
        return PolicyRequirementRule.Tristate.FALSE;
    }
}

